/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.KeyManagement;
import com.mulesoft.b2b.sync.KeyManagementProvider;
import com.mulesoft.b2b.sync.ObjectStoreCloudhubManagement;
import com.mulesoft.b2b.sync.ObjectStoreSimpleManagement;
import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreKeyManagementProvider
implements KeyManagementProvider {
    private static Map<String, KeyManagement> keyManagementMap = new HashMap<String, KeyManagement>();
    private final LockFactory lockFactory;
    private final ObjectStoreManager osManager;
    private final String idObjectStore;
    private final Integer daysToStore;
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreKeyManagementProvider.class);

    public ObjectStoreKeyManagementProvider(LockFactory lockFactory, ObjectStoreManager osManager, String idObjectStore, Integer daysToStore) {
        this.lockFactory = lockFactory;
        this.osManager = osManager;
        this.idObjectStore = idObjectStore;
        this.daysToStore = daysToStore;
    }

    private static synchronized KeyManagement getOrCreateFor(ObjectStoreKeyManagementProvider provider) {
        if (keyManagementMap.containsKey(provider.idObjectStore)) {
            return keyManagementMap.get(provider.idObjectStore);
        }
        ObjectStoreSyncKeyManagement km = null;
        String workerIp = System.getProperty("worker.publicIP");
        km = workerIp != null && workerIp.length() > 0 ? new ObjectStoreCloudhubManagement(provider.osManager, provider.idObjectStore, provider.daysToStore) : new ObjectStoreSimpleManagement(provider.lockFactory, provider.osManager, provider.idObjectStore, provider.daysToStore);
        logger.info("Created " + km.getInfo());
        keyManagementMap.put(provider.idObjectStore, km);
        return km;
    }

    @Override
    public KeyManagement getKeyManagement() {
        return ObjectStoreKeyManagementProvider.getOrCreateFor(this);
    }
}

