/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import java.io.Serializable;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicatedKeyCheck {
    private static final Logger logger = LoggerFactory.getLogger(DuplicatedKeyCheck.class);
    private final ObjectStoreWithLockManager osManager;

    public DuplicatedKeyCheck(ObjectStoreWithLockManager osManager) {
        this.osManager = osManager;
    }

    public synchronized boolean keyNotDuplicated(String keyGroup, String key) {
        return this.osManager.executeWithoutLock(counterObjectStore -> {
            try {
                String keyToUse = keyGroup + "-" + key;
                counterObjectStore.store(keyToUse, (Serializable)((Object)""));
                logger.debug("Key used " + keyToUse);
                return true;
            }
            catch (ObjectAlreadyExistsException e) {
                logger.warn("Key " + key + " already exists for " + keyGroup);
                return false;
            }
            catch (ObjectStoreException e) {
                String excMessage = "Error trying to validate duplicate for " + key + " for " + keyGroup;
                logger.error(excMessage, (Throwable)e);
                throw new RuntimeException(excMessage, e);
            }
        });
    }
}

