/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.key;

import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import com.mulesoft.b2b.sync.key.KeyManagerCoordinator;
import com.mulesoft.b2b.sync.key.KeyManagerState;
import com.mulesoft.b2b.sync.key.KeyOperationResult;
import com.mulesoft.b2b.sync.key.LocalObjectStore;
import com.mulesoft.b2b.sync.key.ReadyState;
import com.mulesoft.b2b.sync.key.WaitingState;
import com.mulesoft.b2b.sync.operation.ObjectStoreOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.mule.runtime.api.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreKeyManagerWithLock {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreKeyManagerWithLock.class);
    private final ObjectStoreSyncKeyManagement objectStoreSyncKeyManagement;
    private final String key;
    private final Scheduler scheduler;
    private KeyManagerState state;
    private Collection<KeyOperationResult> nextJobs;
    private Future futureWork;

    public ObjectStoreKeyManagerWithLock(ObjectStoreSyncKeyManagement objectStoreSyncKeyManagement, Scheduler scheduler, String key) {
        this.objectStoreSyncKeyManagement = objectStoreSyncKeyManagement;
        this.key = key;
        this.readyState();
        this.nextJobs = new ArrayList<KeyOperationResult>();
        this.scheduler = scheduler;
        this.futureWork = null;
    }

    private void readyState() {
        this.state = ReadyState.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> T accept(ObjectStoreOperation<T> operation) {
        logger.info("New job");
        KeyOperationResult result = new KeyOperationResult(operation);
        ObjectStoreKeyManagerWithLock objectStoreKeyManagerWithLock = this;
        synchronized (objectStoreKeyManagerWithLock) {
            this.state.newJob(this, result);
        }
        return (T)this.waitForComplete(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> T waitForComplete(KeyOperationResult<T> result) {
        while (!result.isExecuted()) {
            try {
                KeyOperationResult<T> keyOperationResult = result;
                synchronized (keyOperationResult) {
                    result.wait(4000L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)((Serializable)result.getResult());
    }

    private void notifyCoordinator() {
        KeyManagerCoordinator coordinator = new KeyManagerCoordinator(this);
        this.futureWork = this.scheduler.submit((Callable)coordinator);
    }

    public String getKey() {
        return this.key;
    }

    public <T extends Serializable> void newJob(KeyOperationResult<T> result) {
        this.nextJobs.add(result);
    }

    public void waitingState() {
        if (this.futureWork != null) {
            throw new RuntimeException("Invalid state");
        }
        this.state = WaitingState.getInstance();
        this.notifyCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWithLock() {
        Object object;
        logger.debug("Waiting for lock");
        try {
            this.objectStoreSyncKeyManagement.getLockFor(this);
        }
        catch (Throwable t) {
            this.errorGettingLock(t);
            this.endWorkingState();
            return;
        }
        logger.debug("Lock obtaining. Process all queued jobs");
        ArrayList<KeyOperationResult> resultsToProcess = new ArrayList<KeyOperationResult>();
        try {
            object = this;
            synchronized (object) {
                resultsToProcess.addAll(this.nextJobs);
                this.nextJobs.clear();
            }
            LocalObjectStore localObjectStore = this.getObjectStoreFor(resultsToProcess);
            if (localObjectStore != null) {
                for (KeyOperationResult result : resultsToProcess) {
                    result.execute(localObjectStore);
                }
                this.saveLastValue(localObjectStore, resultsToProcess);
            }
        }
        finally {
            logger.debug("Releasing lock");
            this.objectStoreSyncKeyManagement.releaseLockFor(this);
        }
        object = resultsToProcess.iterator();
        while (object.hasNext()) {
            KeyOperationResult result;
            KeyOperationResult keyOperationResult = result = (KeyOperationResult)object.next();
            synchronized (keyOperationResult) {
                result.notify();
            }
        }
        this.futureWork = null;
        this.endWorkingState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorGettingLock(Throwable exception) {
        ArrayList<KeyOperationResult> resultsToDiscard = new ArrayList<KeyOperationResult>();
        ObjectStoreKeyManagerWithLock objectStoreKeyManagerWithLock = this;
        synchronized (objectStoreKeyManagerWithLock) {
            resultsToDiscard.addAll(this.nextJobs);
            this.nextJobs.clear();
        }
        for (KeyOperationResult toDiscard : resultsToDiscard) {
            toDiscard.notifyException(exception);
            KeyOperationResult keyOperationResult = toDiscard;
            synchronized (keyOperationResult) {
                toDiscard.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWorkingState() {
        ObjectStoreKeyManagerWithLock objectStoreKeyManagerWithLock = this;
        synchronized (objectStoreKeyManagerWithLock) {
            if (this.nextJobs.size() > 0) {
                this.waitingState();
            } else {
                this.readyState();
            }
        }
    }

    private void saveLastValue(LocalObjectStore localObjectStore, Collection<KeyOperationResult> resultsToProcess) {
        this.saveLastValue(localObjectStore, resultsToProcess, true);
    }

    private void saveLastValue(LocalObjectStore localObjectStore, Collection<KeyOperationResult> resultsToProcess, boolean retry) {
        try {
            this.objectStoreSyncKeyManagement.setObjectStoreValueFor(this, localObjectStore.getValue());
        }
        catch (Throwable t) {
            logger.warn("Error saving object store", t);
            if (retry) {
                this.saveLastValue(localObjectStore, resultsToProcess, false);
            }
            for (KeyOperationResult r : resultsToProcess) {
                r.notifyException(t);
            }
        }
    }

    private LocalObjectStore getObjectStoreFor(Collection<KeyOperationResult> resultsToProcess) {
        try {
            return this.objectStoreSyncKeyManagement.createLocalObjectStoreFor(resultsToProcess, this.getKey(), this);
        }
        catch (Throwable t) {
            for (KeyOperationResult r : resultsToProcess) {
                r.notifyException(t);
            }
            return null;
        }
    }
}

