/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import com.mulesoft.b2b.sync.operation.ObjectStoreOperation;
import java.io.Serializable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreCloudhubManagement
extends ObjectStoreSyncKeyManagement {
    private static final long LOCK_WAIT_SECONDS = 15L;
    private static final long BASE_RETRY_DELAY_MS = 140L;
    private static final long MIN_RETRY_DELAY_MS = 50L;
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreCloudhubManagement.class);

    public ObjectStoreCloudhubManagement(Scheduler scheduler, ObjectStoreManager osManager, String idObjectStore, Integer daysToStore) {
        super(scheduler, osManager, idObjectStore, daysToStore);
    }

    @Override
    protected void getLockFor(String key) {
        String lockKey = key + "-LOCK";
        this.osWithRetrys(140L, 50L, "acquire ObjectStore lock " + lockKey, os -> {
            os.store(lockKey, (Serializable)Boolean.TRUE);
            return true;
        });
    }

    @Override
    protected void releaseLockFor(String key) {
        String lockKey = key + "-LOCK";
        this.osWithRetrys(140L, 50L, "release ObjectStore lock " + lockKey, os -> {
            os.remove(lockKey);
            return true;
        });
        logger.debug("Give other workers ability to get lock");
        this.sleepThread(140L);
        logger.debug("Ready to work again");
    }

    private <R> R osWithRetrys(long baseDelay, long minDelay, String task, ObjectStoreOperation<R> body) {
        int attempt = 1;
        long maxTime = System.currentTimeMillis() + 15000L;
        long delay = baseDelay;
        while (System.currentTimeMillis() < maxTime) {
            try {
                R ret = body.apply(this.getCounterObjectStore());
                logger.debug("SUCCESS operation " + task);
                return ret;
            }
            catch (ObjectStoreException e) {
                logger.warn("Can't get lock to " + task + " attempp " + attempt + "[" + e.getMessage() + "]");
                this.sleepThread(delay);
                if (++attempt % 5 != 0) continue;
                delay = Math.max(delay / 2L, minDelay);
            }
        }
        logger.error("Failed trying to " + task + " after " + attempt + " attemps. Waiting " + 15L + " seconds");
        throw new RuntimeException("Failed trying to " + task);
    }

    private void sleepThread(long delay) {
        try {
            Thread.currentThread();
            Thread.sleep(delay);
        }
        catch (InterruptedException e1) {
            logger.error("Interrupted exception", (Throwable)e1);
        }
    }

    @Override
    public String getInfo() {
        return "CloudObjectStore sync for " + super.getInfo();
    }
}

