/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.operation;

import com.mulesoft.b2b.sync.operation.ObjectStoreOperation;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public class GetIntegerFromObjectStore
implements ObjectStoreOperation<Integer> {
    private final String key;
    private final Integer initial;

    public GetIntegerFromObjectStore(String key, Integer initial) {
        this.key = key;
        this.initial = initial;
    }

    @Override
    public Integer apply(ObjectStore counterObjectStore) throws ObjectStoreException {
        Integer count;
        if (counterObjectStore.contains(this.key)) {
            count = this.getIntegerValue(counterObjectStore.retrieve(this.key));
            if (count == null) {
                throw new RuntimeException("Integer value expected for key: " + this.key);
            }
            count = count + 1;
            counterObjectStore.remove(this.key);
        } else {
            count = this.initial;
        }
        counterObjectStore.store(this.key, (Serializable)count);
        return count;
    }

    private Integer getIntegerValue(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof TypedValue) {
            String countVal;
            Object typedValue = ((TypedValue)value).getValue();
            if (typedValue instanceof Integer) {
                return (Integer)typedValue;
            }
            if (typedValue instanceof String && StringUtils.isNumeric((CharSequence)(countVal = (String)typedValue))) {
                return Integer.valueOf(countVal);
            }
        }
        return null;
    }
}

