/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.key;

import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import com.mulesoft.b2b.sync.key.KeyManagerCoordinator;
import com.mulesoft.b2b.sync.key.KeyManagerState;
import com.mulesoft.b2b.sync.key.KeyOperationResult;
import com.mulesoft.b2b.sync.key.LocalObjectStore;
import com.mulesoft.b2b.sync.key.ReadyState;
import com.mulesoft.b2b.sync.key.WaitingState;
import com.mulesoft.b2b.sync.operation.ObjectStoreOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.mule.runtime.api.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreKeyManagerWithLock {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreKeyManagerWithLock.class);
    private final ObjectStoreSyncKeyManagement objectStoreSyncKeyManagement;
    private final String key;
    private final Scheduler scheduler;
    private KeyManagerState state;
    private Collection<KeyOperationResult> nextJobs;
    private Future futureWork;

    public ObjectStoreKeyManagerWithLock(ObjectStoreSyncKeyManagement objectStoreSyncKeyManagement, Scheduler scheduler, String key) {
        this.objectStoreSyncKeyManagement = objectStoreSyncKeyManagement;
        this.key = key;
        this.readyState();
        this.nextJobs = new ArrayList<KeyOperationResult>();
        this.scheduler = scheduler;
    }

    private synchronized void readyState() {
        this.state = ReadyState.getInstance();
        logger.debug(this.getKeyLockInfo() + ": Ready state");
        this.futureWork = null;
    }

    public <T extends Serializable> T accept(ObjectStoreOperation<T> operation) {
        logger.info(this.getKeyLockInfo() + ": New job accepted");
        KeyOperationResult result = new KeyOperationResult(operation);
        this.state.newJob(this, result);
        return (T)this.waitForComplete(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> T waitForComplete(KeyOperationResult<T> result) {
        logger.debug(this.getKeyLockInfo() + ": Wait for obtain result!");
        while (!result.isExecuted()) {
            try {
                KeyOperationResult<T> keyOperationResult = result;
                synchronized (keyOperationResult) {
                    result.wait(4000L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug(this.getKeyLockInfo() + ": Ready to get result!");
        return (T)((Serializable)result.getResult());
    }

    private synchronized void notifyCoordinator() {
        KeyManagerCoordinator coordinator = new KeyManagerCoordinator(this);
        logger.debug(this.getKeyLockInfo() + ": Submitting future work");
        this.futureWork = this.scheduler.submit((Callable)coordinator);
    }

    public String getKey() {
        return this.key;
    }

    public synchronized void newJob(KeyOperationResult result) {
        this.nextJobs.add(result);
        logger.debug(this.getKeyLockInfo() + ": New job added to next jobs. Pending jobs " + this.nextJobs.size());
    }

    public synchronized void waitingState() {
        if (ReadyState.class.equals(this.state.getClass())) {
            if (this.futureWork != null) {
                logger.error(this.getKeyLockInfo() + ": Invalid internal state for key manager. Can't have future work before change from ready to waiting");
                throw new RuntimeException(this.getKeyLockInfo() + ": Invalid state");
            }
            logger.debug(this.getKeyLockInfo() + ": Changing state to Waiting for lock");
            this.state = WaitingState.getInstance();
        } else {
            logger.warn(this.getKeyLockInfo() + ": Waiting state. Future work " + (this.futureWork == null ? "null" : Boolean.valueOf(this.futureWork.isDone())) + " Pending jobs: " + this.nextJobs.size());
        }
        this.notifyCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWithLock() {
        logger.debug(this.getKeyLockInfo() + ": Waiting for lock");
        try {
            this.objectStoreSyncKeyManagement.getLockFor(this);
        }
        catch (Throwable t) {
            this.errorGettingLock(t);
            return;
        }
        logger.debug(this.getKeyLockInfo() + ": Lock obtaining. Process all queued jobs");
        ArrayList<KeyOperationResult> resultsToProcess = new ArrayList<KeyOperationResult>();
        try {
            this.getJobsToProcessInto(resultsToProcess);
            LocalObjectStore localObjectStore = this.getObjectStoreFor(resultsToProcess);
            if (localObjectStore != null) {
                for (KeyOperationResult result : resultsToProcess) {
                    result.execute(localObjectStore);
                }
                this.saveLastValue(localObjectStore, resultsToProcess);
            }
        }
        finally {
            logger.debug(this.getKeyLockInfo() + ": Releasing lock");
            this.objectStoreSyncKeyManagement.releaseLockFor(this);
        }
        Iterator iterator = resultsToProcess.iterator();
        while (iterator.hasNext()) {
            KeyOperationResult result;
            KeyOperationResult keyOperationResult = result = (KeyOperationResult)iterator.next();
            synchronized (keyOperationResult) {
                result.notify();
            }
        }
        this.endWorkingState();
    }

    private synchronized void getJobsToProcessInto(Collection<KeyOperationResult> collection) {
        logger.debug(this.getKeyLockInfo() + ": Jobs to process " + this.nextJobs.size());
        collection.addAll(this.nextJobs);
        this.nextJobs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorGettingLock(Throwable exception) {
        logger.error(this.getKeyLockInfo() + ": Error getting lock. Notify.", exception);
        ArrayList<KeyOperationResult> resultsToDiscard = new ArrayList<KeyOperationResult>();
        logger.debug(this.getKeyLockInfo() + ": Notifying pending jobs. Jobs to notify: " + this.nextJobs.size());
        this.getJobsToProcessInto(resultsToDiscard);
        this.endWorkingState();
        for (KeyOperationResult toDiscard : resultsToDiscard) {
            toDiscard.notifyException(exception);
            KeyOperationResult keyOperationResult = toDiscard;
            synchronized (keyOperationResult) {
                toDiscard.notify();
            }
        }
    }

    private void endWorkingState() {
        if (this.nextJobs.size() > 0) {
            logger.debug(this.getKeyLockInfo() + ": There is still pending jobs. keep waitingState");
            this.notifyCoordinator();
        } else {
            logger.debug(this.getKeyLockInfo() + ": Change state to ready");
            this.readyState();
        }
    }

    private void saveLastValue(LocalObjectStore localObjectStore, Collection<KeyOperationResult> resultsToProcess) {
        this.saveLastValue(localObjectStore, resultsToProcess, true);
    }

    private void saveLastValue(LocalObjectStore localObjectStore, Collection<KeyOperationResult> resultsToProcess, boolean retry) {
        try {
            this.objectStoreSyncKeyManagement.setObjectStoreValueFor(this, localObjectStore.getValue());
        }
        catch (Throwable t) {
            logger.warn(this.getKeyLockInfo() + ": Error saving object store", t);
            if (retry) {
                this.saveLastValue(localObjectStore, resultsToProcess, false);
            }
            for (KeyOperationResult r : resultsToProcess) {
                r.notifyException(t);
            }
        }
    }

    private LocalObjectStore getObjectStoreFor(Collection<KeyOperationResult> resultsToProcess) {
        try {
            return this.objectStoreSyncKeyManagement.createLocalObjectStoreFor(resultsToProcess, this.getKey(), this);
        }
        catch (Throwable t) {
            for (KeyOperationResult r : resultsToProcess) {
                r.notifyException(t);
            }
            return null;
        }
    }

    public String getKeyLockInfo() {
        return this.key + "-LOCK";
    }
}

