/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.key.KeyOperationResult;
import com.mulesoft.b2b.sync.key.LocalObjectStore;
import com.mulesoft.b2b.sync.key.ObjectStoreKeyManagerWithLock;
import com.mulesoft.b2b.sync.operation.ObjectStoreOperation;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectStoreSyncKeyManagement
implements ObjectStoreWithLockManager {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreSyncKeyManagement.class);
    private final ObjectStore counterObjectStore;
    private final String id;
    private Map<String, ObjectStoreKeyManagerWithLock> keyManagers;
    private final Scheduler scheduler;
    protected final LockFactory lockFactory;

    protected ObjectStoreSyncKeyManagement(LockFactory lockFactory, Scheduler scheduler, ObjectStoreManager osManager, String idObjectStore, Integer daysToStore) {
        long ttl = daysToStore.longValue() * 24L * 60L * 60L * 1000L;
        this.counterObjectStore = osManager.getOrCreateObjectStore(idObjectStore, ObjectStoreSettings.builder().persistent(true).maxEntries(Integer.valueOf(0)).entryTtl(Long.valueOf(ttl)).expirationInterval(Long.valueOf(ttl / 4L)).build());
        this.id = idObjectStore + "[" + this.hashCode() + "]";
        this.keyManagers = new HashMap<String, ObjectStoreKeyManagerWithLock>();
        this.scheduler = scheduler;
        this.lockFactory = lockFactory;
    }

    protected ObjectStore getCounterObjectStore() {
        return this.counterObjectStore;
    }

    @Override
    public <T extends Serializable> T executeWithoutLock(ObjectStoreOperation<T> operation) {
        try {
            return (T)((Serializable)operation.apply(this.counterObjectStore));
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerForSync(String key) {
    }

    @Override
    public <T extends Serializable> T executeWithLock(String key, ObjectStoreOperation<T> operation) {
        ObjectStoreKeyManagerWithLock keyManager = this.getKeyManagerFor(key);
        if (keyManager == null) {
            throw new RuntimeException("There is no manager registered for key: " + key);
        }
        return keyManager.accept(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectStoreKeyManagerWithLock getKeyManagerFor(String key) {
        ObjectStoreSyncKeyManagement objectStoreSyncKeyManagement = this;
        synchronized (objectStoreSyncKeyManagement) {
            ObjectStoreKeyManagerWithLock keyManager = this.keyManagers.get(key);
            if (keyManager == null) {
                logger.debug("Registering key manager for key: " + key + "-LOCK");
                keyManager = new ObjectStoreKeyManagerWithLock(this, this.scheduler, key);
                this.keyManagers.put(key, keyManager);
            }
            return keyManager;
        }
    }

    public void getLockFor(ObjectStoreKeyManagerWithLock keyManager) {
        this.checkValidKeyManager(keyManager);
        logger.debug(keyManager.getKeyLockInfo() + ": Try to get lock for " + keyManager.getKey());
        this.getLockFor(keyManager.getKey());
        logger.debug(keyManager.getKeyLockInfo() + ": Lock obtained for " + keyManager.getKey());
    }

    public void releaseLockFor(ObjectStoreKeyManagerWithLock keyManager) {
        this.checkValidKeyManager(keyManager);
        logger.debug(keyManager.getKeyLockInfo() + ": Task finished. Releasing lock for " + keyManager.getKey());
        this.releaseLockFor(keyManager.getKey());
        logger.debug(keyManager.getKeyLockInfo() + ": Lock released for " + keyManager.getKey());
    }

    public Serializable getObjectStoreValueFor(ObjectStoreKeyManagerWithLock keyManager) throws ObjectStoreException {
        this.checkValidKeyManager(keyManager);
        if (this.counterObjectStore.contains(keyManager.getKey())) {
            return this.counterObjectStore.retrieve(keyManager.getKey());
        }
        return null;
    }

    public void setObjectStoreValueFor(ObjectStoreKeyManagerWithLock keyManager, Serializable value) throws ObjectStoreException {
        this.checkValidKeyManager(keyManager);
        if (this.counterObjectStore.contains(keyManager.getKey())) {
            this.counterObjectStore.remove(keyManager.getKey());
        }
        if (value != null) {
            this.counterObjectStore.store(keyManager.getKey(), value);
        }
    }

    private void checkValidKeyManager(ObjectStoreKeyManagerWithLock keyManager) {
        if (!keyManager.equals(this.keyManagers.get(keyManager.getKey()))) {
            throw new RuntimeException("It is no tne manager registered for key: " + keyManager.getKey());
        }
    }

    protected abstract void getLockFor(String var1);

    protected abstract void releaseLockFor(String var1);

    @Override
    public String getInfo() {
        return this.id;
    }

    public LocalObjectStore createLocalObjectStoreFor(Collection<KeyOperationResult> resultsToProcess, String key, ObjectStoreKeyManagerWithLock keyManager) throws ObjectStoreException {
        return new LocalObjectStore(this.counterObjectStore, this.getObjectStoreValueFor(keyManager), key);
    }
}

