/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.provider;

import com.mulesoft.b2b.sync.ObjectStoreCloudhubManagement;
import com.mulesoft.b2b.sync.provider.AbstractObjectStoreWithlockManagerProvider;
import com.mulesoft.b2b.sync.provider.ObjectStoreUsingLockFactory;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.store.ObjectStoreManager;

public class LockWithObjectStoreForCloudHub
extends AbstractObjectStoreWithlockManagerProvider {
    private final boolean cloudhubEnvironment;
    private final ObjectStoreUsingLockFactory objectStoreUsingLockFactory;

    public LockWithObjectStoreForCloudHub(Scheduler scheduler, LockFactory lockFactory, ObjectStoreManager osManager) {
        super(lockFactory, scheduler, osManager);
        String workerIp = System.getProperty("worker.publicIP");
        String forceUsingLockFactory = System.getProperty("forceUsingLockFactory");
        boolean inCloudhub = workerIp != null && workerIp.length() > 0;
        boolean forceLockFactory = "true".equalsIgnoreCase(forceUsingLockFactory);
        this.cloudhubEnvironment = inCloudhub && !forceLockFactory;
        this.objectStoreUsingLockFactory = new ObjectStoreUsingLockFactory(lockFactory, scheduler, osManager);
    }

    @Override
    protected ObjectStoreWithLockManager createObjectStoreWithLockManager(String idObjectStore, Integer daysToStore) {
        return this.cloudhubEnvironment ? new ObjectStoreCloudhubManagement(this.lockFactory, this.scheduler, this.osManager, idObjectStore, daysToStore) : this.objectStoreUsingLockFactory.createObjectStoreWithLockManager(idObjectStore, daysToStore);
    }
}

