/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.provider;

import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectStoreWithlockManagerProvider {
    private static Map<String, ObjectStoreWithLockManager> objectStoreManagementMap;
    protected final LockFactory lockFactory;
    protected final ObjectStoreManager osManager;
    protected final Scheduler scheduler;
    private static final Logger logger;

    public AbstractObjectStoreWithlockManagerProvider(LockFactory lockFactory, Scheduler scheduler, ObjectStoreManager osManager) {
        this.lockFactory = lockFactory;
        this.osManager = osManager;
        this.scheduler = scheduler;
    }

    public static void initKeyManagementMap() {
        objectStoreManagementMap = new HashMap<String, ObjectStoreWithLockManager>();
    }

    private static synchronized ObjectStoreWithLockManager getOrCreateFor(AbstractObjectStoreWithlockManagerProvider provider, String idObjectStore, Integer daysToStore) {
        if (objectStoreManagementMap == null) {
            AbstractObjectStoreWithlockManagerProvider.initKeyManagementMap();
        }
        if (objectStoreManagementMap.containsKey(idObjectStore)) {
            return objectStoreManagementMap.get(idObjectStore);
        }
        ObjectStoreWithLockManager km = provider.createObjectStoreWithLockManager(idObjectStore, daysToStore);
        logger.info("A new ObjectStoreManager for object " + km.getInfo() + " was created");
        objectStoreManagementMap.put(idObjectStore, km);
        return km;
    }

    protected abstract ObjectStoreWithLockManager createObjectStoreWithLockManager(String var1, Integer var2);

    public ObjectStoreWithLockManager getKeyManagement(String idObjectStore, Integer daysToStore) {
        return AbstractObjectStoreWithlockManagerProvider.getOrCreateFor(this, idObjectStore, daysToStore);
    }

    static {
        logger = LoggerFactory.getLogger(AbstractObjectStoreWithlockManagerProvider.class);
    }
}

