/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.DuplicatedKeyCheck;
import com.mulesoft.b2b.sync.provider.LockWithObjectStoreForCloudHub;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSingleton {
    private static final Logger logger = LoggerFactory.getLogger(SyncSingleton.class);
    private static SyncSingleton instance;
    private final ObjectStoreWithLockManager keyManager;
    private final DuplicatedKeyCheck duplicatedKeyCheck;

    private SyncSingleton(SchedulerService service, SchedulerConfig config, LockFactory lockFactory, ObjectStoreManager objectStoreManager, String idObjectStore, Integer daysToStore) {
        logger.debug("Creating new instance of SyncSingleton");
        Scheduler scheduler = service.customScheduler(config.withMaxConcurrentTasks(3).withName("vm-listener-flow-edifact").withWaitAllowed(true).withShutdownTimeout(10L, TimeUnit.SECONDS));
        this.keyManager = new LockWithObjectStoreForCloudHub(scheduler, lockFactory, objectStoreManager).getKeyManagement(idObjectStore, daysToStore);
        this.duplicatedKeyCheck = new DuplicatedKeyCheck(this.keyManager);
    }

    public DuplicatedKeyCheck getDuplicatedKeyCheck() {
        return this.duplicatedKeyCheck;
    }

    public ObjectStoreWithLockManager getKeyManager() {
        return this.keyManager;
    }

    public static synchronized SyncSingleton getInstance(SchedulerService service, SchedulerConfig config, LockFactory lockFactory, ObjectStoreManager objectStoreManager, String idObjectStore, Integer daysToStore) {
        if (instance == null) {
            instance = new SyncSingleton(service, config, lockFactory, objectStoreManager, idObjectStore, daysToStore);
        }
        return instance;
    }
}

