/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.model.common;

import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.model.resolvers.ResolverDeclaration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.TypedValue;

public class SimpleEvaluationContext
implements EvaluationContext {
    private final EvaluationContext globalEvaluationContext;
    private final Map<String, Object> properties;
    private final Map<String, Object> variables;
    private final Map<String, ResolverDeclaration> declarations;

    public SimpleEvaluationContext() {
        this(null);
    }

    public SimpleEvaluationContext(EvaluationContext globalEvaluationContext) {
        this.globalEvaluationContext = globalEvaluationContext;
        this.variables = new HashMap<String, Object>();
        this.properties = new HashMap<String, Object>();
        this.declarations = new HashMap<String, ResolverDeclaration>();
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public Optional<EvaluationContext> getGlobalEvaluationContext() {
        return Optional.ofNullable(this.globalEvaluationContext);
    }

    @Override
    public Object resolve(String expression) {
        ExpressionLanguage expressionLanguage = (ExpressionLanguage)this.resolveProperty("PROPERTY_EXPRESSION_LANGUAGE");
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        this.getVariables().forEach((s, o) -> bindingContextBuilder.addBinding(s, TypedValue.of((Object)o)));
        TypedValue result = expressionLanguage.evaluate(expression, bindingContextBuilder.build());
        if (result == null) {
            throw new RuntimeException(String.format("Unresolvable expression '%s'", expression));
        }
        return result;
    }

    @Override
    public Object resolveProperty(String property) {
        return Optional.ofNullable(this.properties.get(property)).orElseGet(() -> this.getGlobalEvaluationContext().map(evaluationContext -> evaluationContext.resolveProperty(property)).orElse(null));
    }

    @Override
    public void defineProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public void define(String variable, Object value) {
        this.variables.put(variable, value);
    }

    @Override
    public ResolverDeclaration resolveDeclaration(String declarationName) {
        ResolverDeclaration result = Optional.ofNullable(this.declarations.get(declarationName)).orElseGet(() -> this.getGlobalEvaluationContext().map(evaluationContext -> evaluationContext.resolveDeclaration(declarationName)).orElse(null));
        if (result == null) {
            throw new RuntimeException(String.format("Unresolvable declaration '%s'", declarationName));
        }
        return result;
    }

    @Override
    public void declare(ResolverDeclaration resolverDeclaration) {
        this.declarations.put(resolverDeclaration.getName(), resolverDeclaration);
    }
}

