/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.connection;

import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.oauth.OAuthRestConnection;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestSdkUtils;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedOAuthRestConnection
extends OAuthRestConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedOAuthRestConnection.class);
    private final HttpClient httpClient;
    private final OAuthState oauthState;
    private final MultiMap<String, String> defaultQueryParams;
    private final MultiMap<String, String> defaultHeaders;
    private final HttpAuthentication authentication;
    private final ExpressionLanguage expressionLanguage;

    public ExtendedOAuthRestConnection(String baseUri, String configName, HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders, OAuthState oauthState, String resourceOwnerId, ExpressionLanguage expressionLanguage, String refreshTokenCondition) {
        super(baseUri, configName, httpClient, authentication, defaultQueryParams, defaultHeaders, oauthState, resourceOwnerId, expressionLanguage, refreshTokenCondition);
        this.httpClient = httpClient;
        this.oauthState = oauthState;
        this.defaultQueryParams = defaultQueryParams;
        this.defaultHeaders = defaultHeaders;
        this.authentication = authentication;
        this.expressionLanguage = expressionLanguage;
    }

    public CompletableFuture<Result<InputStream, HttpResponseAttributes>> request(HttpRequest request, int responseTimeoutMillis, MediaType defaultResponseMediaType, StreamingHelper streamingHelper) {
        CompletableFuture<Result<InputStream, HttpResponseAttributes>> future = new CompletableFuture<Result<InputStream, HttpResponseAttributes>>();
        try {
            this.httpClient.sendAsync(request, HttpRequestOptions.builder().responseTimeout(responseTimeoutMillis).followsRedirect(true).authentication(this.authentication).build()).whenComplete((response, t) -> {
                try {
                    if (t != null) {
                        this.handleRequestException((Throwable)t, request, future);
                    } else {
                        this.handleResponse((HttpResponse)response, defaultResponseMediaType, future, streamingHelper);
                    }
                }
                catch (MuleRuntimeException var8) {
                    future.completeExceptionally(var8);
                }
                catch (Exception var9) {
                    future.completeExceptionally(new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unhandled exception on completing send async."), (Throwable)var9));
                }
            });
        }
        catch (Exception var8) {
            this.handleRequestException(var8, request, future);
        }
        return future;
    }

    public CompletableFuture<Result<InputStream, HttpResponseAttributes>> request(HttpRequestBuilder requestBuilder, int responseTimeoutMillis, MediaType defaultResponseMediaType, StreamingHelper streamingHelper) {
        this.defaultHeaders.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)requestBuilder).addHeader(arg_0, arg_1));
        this.defaultQueryParams.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)requestBuilder).addQueryParam(arg_0, arg_1));
        return this.request(this.buildRequest(requestBuilder), responseTimeoutMillis, defaultResponseMediaType, streamingHelper);
    }

    private void handleResponse(HttpResponse response, MediaType defaultResponseMediaType, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper) {
        RestError error = RestError.getErrorByCode(response.getStatusCode()).orElse(null);
        if (error != null) {
            this.handleResponseError(response, defaultResponseMediaType, future, streamingHelper, error);
        } else {
            future.complete(this.toResult(response, false, defaultResponseMediaType, streamingHelper));
        }
    }

    private void handleRequestException(Throwable t, HttpRequest request, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future) {
        this.checkIfRemotelyClosed(t, request);
        future.completeExceptionally((Throwable)new ModuleException(t.getMessage(), (ErrorTypeDefinition)(t instanceof TimeoutException ? RestError.TIMEOUT : RestError.CONNECTIVITY), t));
    }

    private void checkIfRemotelyClosed(Throwable exception, HttpRequest request) {
        if ("https".equals(request.getUri().getScheme()) && RestSdkUtils.containsIgnoreCase(exception.getMessage(), "Remotely closed")) {
            LOGGER.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    private HttpRequest buildRequest(HttpRequestBuilder requestBuilder) {
        requestBuilder.addHeader("Authorization", "Bearer " + this.oauthState.getAccessToken());
        return requestBuilder.build();
    }

    public <T> TypedValue<T> applyExpression(String expression, TypedValue<?> payload) {
        TypedValue result = this.expressionLanguage.evaluate(expression, BindingContext.builder().addBinding("payload", payload).build());
        return result;
    }
}

