/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.connection.provider;

import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.OptionalTlsParameterGroup;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.TlsParameterGroup;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.oauth.BaseAuthorizationCodeConnectionProvider;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.validation.ConnectionValidationSettings;
import com.mulesoft.connectors.internal.connection.ExtendedOAuthRestConnection;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

@Alias(value="oauth2c")
@DisplayName(value="Oauth2c Connection Provider")
@AuthorizationCode(accessTokenUrl="https://accounts.google.com/o/oauth2/token", authorizationUrl="https://accounts.google.com/o/oauth2/auth", defaultScopes="https://mail.google.com/ https://www.googleapis.com/auth/gmail.addons.current.action.compose https://www.googleapis.com/auth/gmail.addons.current.message.action https://www.googleapis.com/auth/gmail.addons.current.message.readonly https://www.googleapis.com/auth/gmail.compose https://www.googleapis.com/auth/gmail.insert https://www.googleapis.com/auth/gmail.labels https://www.googleapis.com/auth/gmail.modify https://www.googleapis.com/auth/gmail.readonly https://www.googleapis.com/auth/gmail.send")
public class Oauth2cConnectionProvider
extends BaseAuthorizationCodeConnectionProvider
implements NoConnectivityTest {
    @OAuthParameter(requestAlias="access_type")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="offline")
    private String accessType;
    @DisplayName(value="Base Uri")
    @Summary(value="Parameter base URI, each instance/tenant gets its own")
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="https://www.googleapis.com")
    private String baseUri;
    @Inject
    private ExpressionLanguage expressionLanguage;
    @ParameterGroup(name="tls")
    private OptionalTlsParameterGroup tlsConfig;

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public Optional<TlsParameterGroup> getTlsConfig() {
        return Optional.ofNullable(this.tlsConfig);
    }

    @Override
    protected RestConnection createConnection(HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders) {
        return new ExtendedOAuthRestConnection(this.getBaseUri(), this.getConfigName(), httpClient, authentication, defaultQueryParams, defaultHeaders, (OAuthState)this.getOAuthState(), this.getOAuthState().getResourceOwnerId(), this.getExpressionLanguage(), this.getRefreshTokenCondition());
    }

    @Override
    public ConnectionValidationResult validate(RestConnection restConnection) {
        ConnectionValidationSettings settings = ConnectionValidationSettings.builder("/gmail/v1/users/me/profile", this.expressionLanguage).validStatusCodes(200).build();
        return this.validate(restConnection, settings);
    }
}

