/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operation;

import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.internal.metadata.GmailusersdraftslistOutputMetadataResolver;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GmailusersdraftslistOperation
extends BaseRestOperation {
    private static final Pattern USER_ID_URI_PARAM_PATTERN = Pattern.compile("\\{userId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="List Drafts")
    @Summary(value="Lists the drafts in the user's mailbox.")
    @MediaType(value="application/json")
    @OutputResolver(output=GmailusersdraftslistOutputMetadataResolver.class)
    public void gmailusersdraftslist(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="User Id") @Summary(value="The user's email address. The special value `me` can be used to indicate the authenticated user.") String userIdUriParam, @Optional @DisplayName(value="Max Results") @Summary(value="Maximum number of drafts to return.") Integer maxResultsQueryParam, @Optional @DisplayName(value="Page Token") @Summary(value="Page token to retrieve a specific page of results in the list.") String pageTokenQueryParam, @Optional @DisplayName(value="Query") @Summary(value="Only return draft messages matching the specified query. Supports the same query format as the Gmail search box. For example, `\"from:someuser@example.com rfc822msgid: is:unread\"`.") String qQueryParam, @Optional @DisplayName(value="Include Spam Trash") @Summary(value="Include drafts from `SPAM` and `TRASH` in the results.") boolean includeSpamTrashQueryParam, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/gmail/v1/users/{userId}/drafts";
        requestPath = USER_ID_URI_PARAM_PATTERN.matcher(requestPath).replaceAll(userIdUriParam);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("maxResults", maxResultsQueryParam != null ? String.valueOf(maxResultsQueryParam) : null).addQueryParam("pageToken", pageTokenQueryParam).addQueryParam("q", qQueryParam).addQueryParam("includeSpamTrash", String.valueOf(includeSpamTrashQueryParam));
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

