/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operation;

import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.api.metadata.FormatQueryParamEnum;
import com.mulesoft.connectors.internal.metadata.GmailusersmessagesgetOutputMetadataResolver;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GmailusersmessagesgetOperation
extends BaseRestOperation {
    private static final Pattern USER_ID_URI_PARAM_PATTERN = Pattern.compile("\\{userId}");
    private static final Pattern ID_URI_PARAM_PATTERN = Pattern.compile("\\{id}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Get Message")
    @Summary(value="Gets the specified message.")
    @MediaType(value="application/json")
    @OutputResolver(output=GmailusersmessagesgetOutputMetadataResolver.class)
    public void gmailusersmessagesget(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="User Id") @Summary(value="The user's email address. The special value `me` can be used to indicate the authenticated user.") String userIdUriParam, @DisplayName(value="Message Id") @Summary(value="The ID of the message to retrieve. This ID is usually retrieved using `messages.list`. The ID is also contained in the result when a message is inserted (`messages.insert`) or imported (`messages.import`).") String idUriParam, @Optional @DisplayName(value="format") @Summary(value="The format to return the message in.") FormatQueryParamEnum formatQueryParam, @Optional @NullSafe @DisplayName(value="Metadata Headers") @Summary(value="When given and format is `METADATA`, only include headers specified.") List<String> metadataHeadersQueryParams, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/gmail/v1/users/{userId}/messages/{id}";
        requestPath = USER_ID_URI_PARAM_PATTERN.matcher(requestPath).replaceAll(userIdUriParam);
        requestPath = ID_URI_PARAM_PATTERN.matcher(requestPath).replaceAll(idUriParam);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("format", formatQueryParam != null ? formatQueryParam.getValue() : null).addQueryParams("metadataHeaders", metadataHeadersQueryParams.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

