/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operation;

import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.internal.metadata.GmailuserswatchInputMetadataResolver;
import com.mulesoft.connectors.internal.metadata.GmailuserswatchOutputMetadataResolver;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GmailuserswatchOperation
extends BaseRestOperation {
    private static final Pattern USER_ID_URI_PARAM_PATTERN = Pattern.compile("\\{userId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Setup Push Notifications")
    @Summary(value="Set up or update a push notification watch on the given user mailbox.")
    @MediaType(value="application/json")
    @OutputResolver(output=GmailuserswatchOutputMetadataResolver.class)
    public void gmailuserswatch(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="User Id") @Summary(value="The user's email address. The special value `me` can be used to indicate the authenticated user.") String userIdUriParam, @Content(primary=true) @DisplayName(value="Body") @Summary(value="Set up or update a new push notification watch on this user's mailbox.") @TypeResolver(value=GmailuserswatchInputMetadataResolver.class) TypedValue<InputStream> gmailuserswatchBody, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/gmail/v1/users/{userId}/watch";
        requestPath = USER_ID_URI_PARAM_PATTERN.matcher(requestPath).replaceAll(userIdUriParam);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.POST, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("content-type", "application/json").addHeader("accept", "application/json").setBody(gmailuserswatchBody, overrides.getStreamingType());
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

