/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operation.sidecar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectors.api.EmailAttachment;
import com.mulesoft.connectors.internal.config.GmailConfiguration;
import com.mulesoft.connectors.internal.metadata.sidecar.GetAttachmentOutputMetadataResolver;
import com.mulesoft.connectors.internal.operation.sidecar.sampledata.GetAttachmentSampleDataProvider;
import com.mulesoft.connectors.internal.source.dto.GmailMessagePartBody;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.Ignore;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public class GetAttachmentOperation {
    private static final Pattern USER_ID_URI_PARAM_PATTERN = Pattern.compile("\\{userId}");
    private static final Pattern MESSAGE_ID_URI_PARAM_PATTERN = Pattern.compile("\\{messageId}");
    private static final Pattern ID_URI_PARAM_PATTERN = Pattern.compile("\\{id}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Ignore
    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Get Attachment Citizen")
    @Summary(value="Gets the specified message attachment content.")
    @SampleData(value=GetAttachmentSampleDataProvider.class)
    @OutputResolver(output=GetAttachmentOutputMetadataResolver.class)
    @MediaType(value="*/*")
    public void getAttachment(@Config GmailConfiguration config, @Connection RestConnection connection, @DisplayName(value="Message Id") @Summary(value="The ID of the message containing the attachment.") String messageId, @DisplayName(value="Attachment Id") @Summary(value="The ID of the attachment.") String attachmentId, @DisplayName(value="Attachment File Name") @Summary(value="The attachment file name with extension") String fileName, @DisplayName(value="Attachment MIME Type") @Summary(value="The attachment MIME type") String mimeType, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<EmailAttachment, Void> completionCallback) {
        String requestPath = "/gmail/v1/users/{userId}/messages/{messageId}/attachments/{id}";
        requestPath = USER_ID_URI_PARAM_PATTERN.matcher(requestPath).replaceAll("me");
        requestPath = MESSAGE_ID_URI_PARAM_PATTERN.matcher(requestPath).replaceAll(messageId);
        requestPath = ID_URI_PARAM_PATTERN.matcher(requestPath).replaceAll(attachmentId);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json");
        Result<InputStream, HttpResponseAttributes> result = RequestStreamingUtils.doRequest(connection, config, builder, org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON);
        TypedValue<String> rawContent = RestSdkUtils.consumeStringAndClose(result.getOutput(), result.getMediaType().orElse(org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON), RestSdkUtils.resolveCharset(result.getMediaType(), org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON));
        try {
            GmailMessagePartBody rawResponse = (GmailMessagePartBody)config.getObjectMapper().readValue((String)rawContent.getValue(), GmailMessagePartBody.class);
            byte[] decodedOutput = Base64.getUrlDecoder().decode(rawResponse.getData());
            completionCallback.success(Result.builder().output((Object)new EmailAttachment(new ByteArrayInputStream(decodedOutput), String.valueOf(rawResponse.getSize()), attachmentId, fileName, mimeType)).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JAVA).build());
        }
        catch (JsonProcessingException e) {
            completionCallback.error((Throwable)e);
        }
    }
}

