/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operation.sidecar;

import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.api.EmailAttachment;
import com.mulesoft.connectors.internal.connection.ExtendedOAuthRestConnection;
import com.mulesoft.connectors.internal.metadata.sidecar.SendMessageOutputMetadataResolver;
import com.mulesoft.connectors.internal.operation.sidecar.sampledata.SendMessageSampleDataProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.logging.log4j.util.Strings;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.Ignore;
import org.mule.sdk.api.annotation.data.sample.SampleData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageOperation
extends BaseRestOperation {
    private static final String INVALID_EMAIL = "Email address 'null' specify at least one correct email address, e.g. example@example.com";
    private static final String MESSAGE_ERROR = "Error sending message";
    private static final String ATTACHMENT_MESSAGE_ERROR = "The size for all attachments and message body content must be less than 25MB";
    private static final long MAX_ATTACHMENT_SIZE = 0x1900000L;
    private static final String RESOURCE = "/gmail/v1/users/me/messages/send";
    private static final String ID_EXPRESSION = "#[output application/json --- {\"emailId\": payload.id}]";
    private static final String MULTIPART_MEDIA_TYPE = org.mule.runtime.api.metadata.MediaType.MULTIPART_RELATED.toString();
    private static final String DEFAULT_MEDIA_TYPE = org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON.toString();
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;
    private final Session session = Session.getDefaultInstance((Properties)new Properties());
    private static final Logger logger = LoggerFactory.getLogger(SendMessageOperation.class);

    @Ignore
    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Send email")
    @Summary(value="Sends the specified message to the recipients in the <code>To</code> headers.")
    @SampleData(value=SendMessageSampleDataProvider.class)
    @OutputResolver(output=SendMessageOutputMetadataResolver.class)
    @MediaType(value="application/json")
    public void sendEmail(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Recipients") @Summary(value="Email address of the recipients.") List<String> recipients, @DisplayName(value="Subject") @Summary(value="Subject of the email.") String subject, @DisplayName(value="Body") TypedValue<String> body, @NullSafe @org.mule.runtime.extension.api.annotation.param.Optional @DisplayName(value="Attachment list") @Summary(value="Attachment List") List<EmailAttachment> attachments, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> completionCallback) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            MimeMessage email = new MimeMessage(this.session);
            email.setFrom((Address)new InternetAddress("me"));
            email.setSubject(subject);
            email.addRecipients(Message.RecipientType.TO, (Address[])this.validateEmail(String.join((CharSequence)", ", recipients)));
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart mailBodyPart = new MimeBodyPart();
            mailBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(Optional.ofNullable(body).map(TypedValue::getValue).orElse(""), String.format("%s; charset=%s", "text/plain", config.getCharset()))));
            multipart.addBodyPart((BodyPart)mailBodyPart);
            for (EmailAttachment attachment : attachments) {
                String fileContentType = attachment.getFiletype();
                if (Strings.isEmpty((CharSequence)fileContentType)) {
                    File file = new File(attachment.getName());
                    URLConnection fileUrlConn = file.toURL().openConnection();
                    fileContentType = fileUrlConn.getContentType();
                }
                logger.debug("MIME type : " + fileContentType);
                MimeBodyPart fileBodyPart = new MimeBodyPart();
                ByteArrayDataSource fileSource = new ByteArrayDataSource(attachment.getContent(), fileContentType);
                fileBodyPart.setDataHandler(new DataHandler((DataSource)fileSource));
                fileBodyPart.setHeader("Content-Type", fileContentType + "; name=\"" + attachment.getName() + "\"");
                fileBodyPart.setHeader("Content-Transfer-Encoding", "base64");
                fileBodyPart.setHeader("Content-Disposition", "attachment; filename=\"" + attachment.getName() + "\"");
                fileBodyPart.setFileName(attachment.getName());
                multipart.addBodyPart((BodyPart)fileBodyPart);
            }
            email.setContent((Multipart)multipart);
            email.writeTo((OutputStream)outputStream);
            byte[] outputStreamBytes = outputStream.toByteArray();
            if ((long)outputStreamBytes.length >= 0x1900000L) {
                throw new ModuleException(ATTACHMENT_MESSAGE_ERROR, (ErrorTypeDefinition)MuleErrors.CONNECTIVITY);
            }
            byte[] base64EncodedEmail = Base64.getEncoder().encode(outputStreamBytes);
            outputStream.reset();
            outputStream.write("{\"raw\":\"".getBytes());
            outputStream.write(base64EncodedEmail);
            outputStream.write("\"}".getBytes());
            DataType dataType = DataType.builder().type(InputStream.class).mediaType(MULTIPART_MEDIA_TYPE + "; charset=" + config.getCharset().name()).build();
            TypedValue finalBodyTypedValue = new TypedValue((Object)new ByteArrayInputStream(outputStream.toByteArray()), dataType);
            RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), RESOURCE, HttpConstants.Method.POST, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("Content-Type", MULTIPART_MEDIA_TYPE).addHeader("Accept", DEFAULT_MEDIA_TYPE).addQueryParam("alt", "json").addQueryParam("$.xgafv", "1").setBody((TypedValue<InputStream>)finalBodyTypedValue, overrides.getStreamingType());
            connection.request(builder, overrides.getResponseTimeoutAsMillis(), org.mule.runtime.api.metadata.MediaType.ANY, streamingHelper).whenComplete((result, error) -> {
                if (error != null) {
                    completionCallback.error(error);
                } else {
                    completionCallback.success(Result.builder().output((Object)((InputStream)((ExtendedOAuthRestConnection)connection).applyExpression(ID_EXPRESSION, new TypedValue((Object)((InputStream)result.getOutput()), DataType.JSON_STRING)).getValue())).attributes((Object)result.getAttributes().orElse(null)).build());
                }
            });
        }
        catch (IOException | MessagingException e) {
            throw new ModuleException(MESSAGE_ERROR, (ErrorTypeDefinition)MuleErrors.CONNECTIVITY, e);
        }
    }

    private InternetAddress[] validateEmail(String emails) {
        try {
            return InternetAddress.parse((String)emails);
        }
        catch (NullPointerException | AddressException e) {
            throw new ModuleException(INVALID_EMAIL, (ErrorTypeDefinition)RestError.BAD_REQUEST, e);
        }
    }
}

