/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.source;

import com.mulesoft.connectors.internal.source.dto.GmailMessage;
import com.mulesoft.connectors.internal.source.dto.GmailMessagePart;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;

public class Message
implements Serializable {
    private static final long serialVersionUID = 7944248373456819043L;
    private static final Pattern ANGLE_BRACKETS_PATTERN = Pattern.compile("<(.*?)>");
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=\\\"(.*?)\\\"");
    private String id;
    private String from;
    private String to;
    private String senderName;
    private String subject;
    private List<String> cc;
    private List<String> bcc;
    private TypedValue<String> body;
    private List<String> attachmentIds;

    private Message() {
    }

    public static Message from(GmailMessage gmailMessage) {
        Message message = new Message();
        message.id = gmailMessage.getId();
        Map<String, String> headers = gmailMessage.getPayload().getHeaders();
        message.from = Message.extractEmail(headers.get("From"));
        message.senderName = Message.extractName(headers.get("From"));
        message.to = Message.extractEmail(headers.get("To"));
        message.subject = headers.get("Subject");
        message.cc = Message.extractEmails(headers, "Cc");
        message.bcc = Message.extractEmails(headers, "Bcc");
        message.body = Message.extractBody(gmailMessage);
        message.attachmentIds = Message.resolveAttachments(gmailMessage);
        return message;
    }

    private static String extractName(String from) {
        String[] split = from.split("<");
        if (split.length == 2) {
            return split[0].trim();
        }
        return null;
    }

    private static TypedValue<String> extractBody(GmailMessage gmailMessage) {
        try {
            if (gmailMessage.getPayload().getBody().getSize() != 0) {
                return Message.decodeMessageBody(gmailMessage.getPayload().getBody().getData(), gmailMessage.getPayload().getHeaders());
            }
            return Message.extractBodyFromParts(gmailMessage.getPayload().getParts());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static TypedValue<String> extractBodyFromParts(List<GmailMessagePart> parts) throws IOException {
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        GmailMessagePart firstPart = parts.get(0);
        if (firstPart.getBody().getSize() != 0 && "text/plain".equals(firstPart.getMimeType())) {
            return Message.decodeMessageBody(firstPart.getBody().getData(), firstPart.getHeaders());
        }
        return Message.extractBodyFromParts(firstPart.getParts());
    }

    private static TypedValue<String> decodeMessageBody(String body, Map<String, String> headers) throws IOException {
        String charset = Message.getCharset(headers).orElse("UTF-8");
        return new TypedValue((Object)new String(Base64.getUrlDecoder().decode(body), charset), DataType.TEXT_STRING);
    }

    private static Optional<String> getCharset(Map<String, String> headers) {
        Matcher matcher;
        String contentType;
        if (headers != null && (contentType = headers.get("Content-Type")) != null && (matcher = CHARSET_PATTERN.matcher(contentType)).find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private static List<String> extractEmails(Map<String, String> headers, String headerName) {
        if (headers.get(headerName) == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(headers.get(headerName).split(",")).map(Message::extractEmail).collect(Collectors.toList());
    }

    private static String extractEmail(String stringWithEmail) {
        Matcher m = ANGLE_BRACKETS_PATTERN.matcher(stringWithEmail);
        if (m.find()) {
            return m.group(1);
        }
        return stringWithEmail.trim();
    }

    private static List<String> resolveAttachments(GmailMessage gmailMessage) {
        List<String> resolvedAttachmentIds = new ArrayList<String>();
        List<GmailMessagePart> parts = gmailMessage.getPayload().getParts();
        if (parts != null) {
            resolvedAttachmentIds = parts.stream().filter(GmailMessagePart::isAttachment).map(part -> part.getBody().getAttachmentId()).filter(attachmentId -> attachmentId != null && !attachmentId.equals("")).collect(Collectors.toList());
        }
        return resolvedAttachmentIds;
    }

    public String getId() {
        return this.id;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public TypedValue<String> getBody() {
        return this.body;
    }

    public List<String> getAttachmentIds() {
        return this.attachmentIds;
    }
}

