/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.source;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectors.internal.config.GmailConfiguration;
import com.mulesoft.connectors.internal.connection.ExtendedOAuthRestConnection;
import com.mulesoft.connectors.internal.metadata.GmailusersmessageslistOutputMetadataResolver;
import com.mulesoft.connectors.internal.source.GmailWatermark;
import com.mulesoft.connectors.internal.source.dto.GmailMessage;
import com.mulesoft.connectors.internal.source.processor.GmailPagingProcessor;
import com.mulesoft.connectors.internal.source.processor.SourceComponent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MediaType(value="application/json")
@DisplayName(value="On New Email")
@Alias(value="on-new-email-listener")
@ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
@Summary(value="Enters the flow whenever a new email is received.")
@MetadataScope(outputResolver=GmailusersmessageslistOutputMetadataResolver.class)
public class OnNewEmailSource
extends PollingSource<InputStream, HttpResponseAttributes>
implements SourceComponent<PollContext<InputStream, HttpResponseAttributes>> {
    protected static final Logger logger = LoggerFactory.getLogger(OnNewEmailSource.class);
    @Config
    private GmailConfiguration config;
    @Connection
    private ConnectionProvider<ExtendedOAuthRestConnection> connectionProvider;
    private ExtendedOAuthRestConnection connection;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @DisplayName(value="After")
    @Summary(value="Date from which (including) the emails will be polled. The format of date is yyyy/mm/dd")
    @Example(value="2021/7/2")
    private String after;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="")
    @DisplayName(value="Search Query")
    @Summary(value="Search phrase such as \"in:label\", \"from:foo@bar.com\"")
    @Example(value="from:foo@bar.com")
    private String query;
    private GmailPagingProcessor<PollContext<InputStream, HttpResponseAttributes>> processor;

    protected void doStart() throws MuleException {
        this.connection = (ExtendedOAuthRestConnection)this.connectionProvider.connect();
        this.processor = new GmailPagingProcessor<PollContext<InputStream, HttpResponseAttributes>>(this.connection, this.config, this, this.after, this.query);
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void poll(PollContext<InputStream, HttpResponseAttributes> pollContext) {
        this.processor.poll(pollContext, pollContext.getWatermark().orElse(null));
    }

    public void onRejectedItem(Result<InputStream, HttpResponseAttributes> result, SourceCallbackContext callbackContext) {
        this.processor.handleRejectItem((InputStream)result.getOutput());
    }

    @Override
    public void onConnectionException(PollContext<InputStream, HttpResponseAttributes> context, ConnectionException exception) {
        context.onConnectionException(exception);
    }

    @Override
    public void accept(PollContext<InputStream, HttpResponseAttributes> context, GmailMessage gmailMessage, GmailWatermark watermark, Optional<HttpResponseAttributes> httpResponseAttributes) {
        PollContext.PollItemStatus itemStatus = context.accept(pollItem -> {
            try {
                Result itemResult = Result.builder().output((Object)new ByteArrayInputStream(this.config.getObjectMapper().writeValueAsBytes((Object)gmailMessage))).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON).attributes((Object)httpResponseAttributes.orElse(null)).build();
                pollItem.setResult(itemResult);
                pollItem.setId(gmailMessage.getId());
                pollItem.setWatermark((Serializable)watermark);
            }
            catch (JsonProcessingException e) {
                logger.warn("Trigger '{}': Exception while serializing MuleMessage into bytes in poll consumer: '{}'", new Object[]{this.getId(), e.getMessage(), e});
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("Item {} {} processing result - {}", new Object[]{gmailMessage.getId(), gmailMessage.getInternalDate(), itemStatus.name()});
        }
    }

    @Override
    public String getId() {
        return this.getClass().getSimpleName();
    }
}

