/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.source.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.mulesoft.connectors.internal.source.dto.GmailHeader;
import com.mulesoft.connectors.internal.source.dto.GmailMessagePartBody;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GmailMessagePart {
    private String partId;
    private String mimeType;
    private String filename;
    private Map<String, String> headers;
    private GmailMessagePartBody body;
    private List<GmailMessagePart> parts;

    @JsonSetter(value="headers")
    public void jsonParseHeaders(List<GmailHeader> gmailHeaders) {
        this.headers = gmailHeaders.stream().collect(Collectors.toMap(GmailHeader::getName, GmailHeader::getValue, (item1, item2) -> item1));
    }

    @JsonIgnore
    public boolean isAttachment() {
        if (this.headers != null) {
            String disposition = this.headers.get("Content-Disposition");
            return disposition != null && disposition.startsWith("attachment;");
        }
        return false;
    }

    public String getPartId() {
        return this.partId;
    }

    public void setPartId(String partId) {
        this.partId = partId;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public GmailMessagePartBody getBody() {
        return this.body;
    }

    public void setBody(GmailMessagePartBody body) {
        this.body = body;
    }

    public List<GmailMessagePart> getParts() {
        return this.parts;
    }

    public void setParts(List<GmailMessagePart> parts) {
        this.parts = parts;
    }
}

