/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.source.pagination;

import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectors.internal.config.GmailConfiguration;
import com.mulesoft.connectors.internal.connection.ExtendedOAuthRestConnection;
import com.mulesoft.connectors.internal.error.exception.GmailException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.message.ds.InputStreamDataSource;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public class BatchPageProvider<T>
implements PagingProvider<ExtendedOAuthRestConnection, Result<T, HttpResponseAttributes>> {
    private static final String BATCH_URL = "batch/gmail/v1";
    protected final GmailConfiguration config;
    private final Class<T> mappedClass;
    private final int batchSize;
    private final List<HttpRequest> requests;
    private int position;

    public BatchPageProvider(GmailConfiguration config, int batchSize, List<HttpRequest> requests, Class<T> mappedClass) {
        this.batchSize = batchSize;
        this.requests = requests;
        this.position = 0;
        this.config = config;
        this.mappedClass = mappedClass;
    }

    public List<Result<T, HttpResponseAttributes>> getPage(ExtendedOAuthRestConnection connection) {
        try {
            List httpParts = this.requests.subList(this.position, Math.min(this.requests.size(), this.position + this.batchSize)).stream().map(this::toHttpPart).collect(Collectors.toList());
            this.position += this.batchSize;
            HttpRequestBuilder batchRequest = (HttpRequestBuilder)HttpRequest.builder().uri(String.format("%s/%s", connection.getBaseUri(), BATCH_URL)).method(HttpConstants.Method.POST).entity((HttpEntity)new MultipartHttpEntity(httpParts));
            Result<InputStream, HttpResponseAttributes> result = connection.request(batchRequest, this.config.getResponseTimeoutMillis(), MediaType.APPLICATION_JSON, null).get();
            MimeMultipart multipart = new MimeMultipart((DataSource)new InputStreamDataSource((InputStream)result.getOutput(), MediaType.APPLICATION_JSON, ""));
            return IntStream.range(0, multipart.getCount()).mapToObj(i -> this.extractBodyPart(multipart, i)).map(part -> Result.builder().output(this.resolveMultipartPayload((BodyPart)part)).attributes((Object)result.getAttributes().orElse(null)).build()).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GmailException("Paging interrupted.", (ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY, e);
        }
        catch (ExecutionException | MessagingException e) {
            throw new GmailException("Paging request exception", (ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY, e);
        }
    }

    public Optional<Integer> getTotalResults(ExtendedOAuthRestConnection connection) {
        return Optional.of(this.requests.size());
    }

    public void close(ExtendedOAuthRestConnection connection) throws MuleException {
    }

    public boolean hasNext() {
        return this.position < this.requests.size();
    }

    private BodyPart extractBodyPart(MimeMultipart multipart, int index) {
        try {
            return multipart.getBodyPart(index);
        }
        catch (MessagingException e) {
            throw new GmailException("Failed to extract body part from MultiPart response.", (ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY, e);
        }
    }

    private HttpPart toHttpPart(HttpRequest request) {
        try {
            StringBuilder content = new StringBuilder();
            content.append(String.format("%s %s", request.getMethod(), request.getUri()));
            if (!request.getQueryParams().isEmpty()) {
                content.append(request.getQueryParams().entryList().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&", "?", "")));
            }
            content.append("\r\n");
            request.getHeaders().forEach((name, value) -> content.append(String.format("%s: %s\r\n", name, value)));
            if (request.getEntity() != null) {
                content.append("\r\n");
                content.append(Arrays.toString(request.getEntity().getBytes()));
            }
            return new HttpPart(UUID.randomUUID().toString(), content.toString().getBytes(), "application/json", content.length());
        }
        catch (IOException e) {
            throw new GmailException("Failed to serialize request into MultiPart.", (ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY, e);
        }
    }

    private T resolveMultipartPayload(BodyPart part) {
        try {
            String response = IOUtils.toString((InputStream)part.getInputStream());
            String[] split = response.split("\r\n", 2);
            MimeBodyPart innerPart = new MimeBodyPart((InputStream)new ByteArrayInputStream(split[1].getBytes()));
            return (T)this.config.getObjectMapper().readValue(innerPart.getInputStream(), this.mappedClass);
        }
        catch (MessagingException e) {
            throw new GmailException("Failed to serialize MultiPart Body into GmailMessage", RestError.INTERNAL_SERVER_ERROR, e);
        }
        catch (IOException e) {
            throw new GmailException("Failed to access MultiPart body content.", RestError.INTERNAL_SERVER_ERROR, e);
        }
    }
}

