/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.source.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectors.internal.config.GmailConfiguration;
import com.mulesoft.connectors.internal.connection.ExtendedOAuthRestConnection;
import com.mulesoft.connectors.internal.source.GmailWatermark;
import com.mulesoft.connectors.internal.source.dto.GmailMessage;
import com.mulesoft.connectors.internal.source.dto.GmailMessageId;
import com.mulesoft.connectors.internal.source.dto.ListGmailMessagesResponse;
import com.mulesoft.connectors.internal.source.pagination.BatchPageProvider;
import com.mulesoft.connectors.internal.source.processor.SourceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GmailPagingProcessor<T> {
    protected static final Logger logger = LoggerFactory.getLogger(GmailPagingProcessor.class);
    protected static final String GMAIL_API = "/gmail/v1";
    protected static final String MESSAGES_PATH = "/gmail/v1/users/me/messages";
    protected static final String BEFORE_REGEX = "before:(\\w+\\/\\w+\\/\\w+|\\w+)";
    protected static final String AFTER_REGEX = "after:(\\w+\\/\\w+\\/\\w+|\\w+)";
    protected static final String MULTI_SPACE_REGEX = " +";
    private final GmailConfiguration config;
    private final ExtendedOAuthRestConnection connection;
    private final SourceComponent<T> sourceComponent;
    private final String after;
    private String preparedQuery;

    public GmailPagingProcessor(ExtendedOAuthRestConnection connection, GmailConfiguration config, SourceComponent<T> sourceComponent, String after, String query) {
        this.connection = connection;
        this.config = config;
        this.after = after;
        this.preparedQuery = this.prepareQuery(query);
        this.sourceComponent = sourceComponent;
    }

    public void poll(T context, GmailWatermark watermark) {
        ObjectMapper objectMapper = this.config.getObjectMapper();
        RestRequestBuilder messagesRequestBuilder = new RestRequestBuilder(this.connection.getBaseUri(), MESSAGES_PATH, HttpConstants.Method.GET);
        this.preparePollRequest(messagesRequestBuilder, watermark);
        InputStream listMessagesPayload = this.execute(context, messagesRequestBuilder).map(Result::getOutput).orElse(null);
        if (listMessagesPayload == null) {
            logger.debug("NULL PAYLOAD retrieved!!!");
            return;
        }
        try {
            ListGmailMessagesResponse listGmailMessagesResponse = (ListGmailMessagesResponse)objectMapper.readValue(listMessagesPayload, ListGmailMessagesResponse.class);
            if (listGmailMessagesResponse.hasMessages()) {
                this.handleMessages(context, watermark, listGmailMessagesResponse);
            } else {
                logger.debug("No messages retrieved.");
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Trigger '%s': Exception while deserializing class while polling: '%s'", this.sourceComponent.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
        }
    }

    public String prepareQuery(String query) {
        String queryResult = query.replaceAll(BEFORE_REGEX, "");
        queryResult = queryResult.replaceAll(AFTER_REGEX, "");
        queryResult = queryResult.trim().replaceAll(MULTI_SPACE_REGEX, " ");
        if (this.after != null) {
            queryResult = queryResult + " after:" + this.after;
        }
        return queryResult;
    }

    private void handleMessages(T context, GmailWatermark watermark, ListGmailMessagesResponse listGmailMessagesResponse) {
        long maxDateInSeconds = 0L;
        String maxMessageId = null;
        BatchPageProvider<GmailMessage> pageProvider = new BatchPageProvider<GmailMessage>(this.config, 100, listGmailMessagesResponse.getMessages().stream().map(this::createHttpRequest).collect(Collectors.toList()), GmailMessage.class);
        boolean first = true;
        while (pageProvider.hasNext()) {
            for (Result<GmailMessage, HttpResponseAttributes> result : pageProvider.getPage(this.connection)) {
                GmailMessage gmailMessage = (GmailMessage)result.getOutput();
                if (first) {
                    first = false;
                    maxDateInSeconds = Long.parseLong(gmailMessage.getInternalDate()) / 1000L;
                    maxMessageId = gmailMessage.getId();
                    if (watermark != null) {
                        maxDateInSeconds = Math.max(watermark.getMaxDateInSeconds(), maxDateInSeconds);
                        maxMessageId = GmailPagingProcessor.maxId(watermark.getMaxMessageId(), maxMessageId);
                    }
                }
                logger.debug("Send item with id: '{}' and internal date: '{}' for processing.", (Object)gmailMessage.getId(), (Object)gmailMessage.getInternalDate());
                logger.debug("Current watermark {}", watermark != null ? watermark : "N/A");
                GmailWatermark nextWatermark = new GmailWatermark(gmailMessage.getId(), maxMessageId, listGmailMessagesResponse.getNextPageToken(), maxDateInSeconds);
                logger.debug("Item watermark {}", (Object)nextWatermark);
                this.sourceComponent.accept(context, gmailMessage, nextWatermark, result.getAttributes());
            }
        }
    }

    private HttpRequest createHttpRequest(GmailMessageId gmailMessageId) {
        return this.sourceComponent.createHttpRequest(HttpRequest.builder().method("GET").uri(String.format("/gmail/v1/users/me/messages/%s", gmailMessageId.getId())));
    }

    private void preparePollRequest(RestRequestBuilder requestBuilder, GmailWatermark watermark) {
        if (watermark != null) {
            if (watermark.getNextToken() != null) {
                requestBuilder.addQueryParam("pageToken", watermark.getNextToken());
            } else {
                this.preparedQuery = this.preparedQuery.replaceAll(AFTER_REGEX, "").trim().replaceAll(MULTI_SPACE_REGEX, " ");
                this.preparedQuery = this.preparedQuery + " after:" + (watermark.getMaxDateInSeconds() + 1L);
            }
        }
        logger.debug("Poll query {}", (Object)this.preparedQuery);
        requestBuilder.addQueryParam("q", this.preparedQuery);
    }

    public Optional<Result<InputStream, HttpResponseAttributes>> execute(T pollContext, RestRequestBuilder restRequestBuilder) {
        try {
            return Optional.of(RequestStreamingUtils.doRequest(this.connection, this.config, restRequestBuilder, MediaType.APPLICATION_JSON));
        }
        catch (AccessTokenExpiredException e) {
            logger.info(String.format("Trigger '%s': Access token expired...", this.sourceComponent.getId()), (Throwable)e);
            this.sourceComponent.onConnectionException(pollContext, new ConnectionException((Throwable)e));
            logger.info(String.format("Trigger '%s': access token expiration notified to runtime.", this.sourceComponent.getId()), (Throwable)e);
        }
        catch (MuleRuntimeException e) {
            logger.warn(String.format("Trigger '%s': Mule runtime exception found while executing poll: '%s'", this.sourceComponent.getId(), e.getMessage()), (Throwable)e);
        }
        return Optional.empty();
    }

    public void handleRejectItem(InputStream resultOutputStream) {
        if (resultOutputStream != null) {
            try {
                GmailMessageId messageId = (GmailMessageId)this.config.getObjectMapper().readValue(resultOutputStream, GmailMessageId.class);
                logger.debug("Item Rejected: '{}' on Gmail thread '{}'", (Object)messageId.getId(), (Object)messageId.getThreadId());
            }
            catch (IOException e) {
                logger.debug("Failed to deserialize rejected item");
            }
            finally {
                RestSdkUtils.closeStream(resultOutputStream);
            }
        } else {
            logger.debug("Null Item Rejected");
        }
    }

    public static int compareMessageIds(String itemMessageId, String watermarkMessageId) {
        return itemMessageId.length() == watermarkMessageId.length() ? itemMessageId.compareTo(watermarkMessageId) : Long.compare(itemMessageId.length(), watermarkMessageId.length());
    }

    private static String maxId(String id1, String id2) {
        return GmailPagingProcessor.compareMessageIds(id1, id2) < 0 ? id2 : id1;
    }
}

