/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.source.sidecar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectors.internal.config.GmailConfiguration;
import com.mulesoft.connectors.internal.connection.ExtendedOAuthRestConnection;
import com.mulesoft.connectors.internal.metadata.sidecar.OnNewEmailSourceOutputMetadataResolver;
import com.mulesoft.connectors.internal.source.GmailWatermark;
import com.mulesoft.connectors.internal.source.Message;
import com.mulesoft.connectors.internal.source.dto.GmailMessage;
import com.mulesoft.connectors.internal.source.processor.GmailPagingProcessor;
import com.mulesoft.connectors.internal.source.processor.SourceComponent;
import com.mulesoft.connectors.internal.source.sidecar.sampledata.TriggerMessageSampleDataProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.annotation.Ignore;
import org.mule.sdk.api.annotation.data.sample.SampleData;
import org.mule.sdk.api.annotation.source.ClusterSupport;
import org.mule.sdk.api.annotation.source.SourceClusterSupport;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.PollContext;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@DisplayName(value="On New Email")
@Alias(value="on-new-email-citizen-listener")
@MediaType(value="application/json")
@ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
@Summary(value="Enters the flow whenever a new email is received.")
@SampleData(value=TriggerMessageSampleDataProvider.class)
@MetadataScope(outputResolver=OnNewEmailSourceOutputMetadataResolver.class)
public class OnNewEmailCitizenSource
extends PollingSource<InputStream, HttpResponseAttributes>
implements SourceComponent<PollContext<InputStream, HttpResponseAttributes>> {
    private static final Logger logger = LoggerFactory.getLogger(OnNewEmailCitizenSource.class);
    @Config
    private GmailConfiguration config;
    @Connection
    private ConnectionProvider<ExtendedOAuthRestConnection> connectionProvider;
    private ExtendedOAuthRestConnection connection;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="")
    @DisplayName(value="Search Query")
    @Summary(value="Search phrase such as \"in:label\", \"from:foo@bar.com\"")
    @Example(value="from:foo@bar.com")
    private String query;
    private GmailPagingProcessor<PollContext<InputStream, HttpResponseAttributes>> processor;

    protected void doStart() throws MuleException {
        this.connection = (ExtendedOAuthRestConnection)this.connectionProvider.connect();
        this.processor = new GmailPagingProcessor<PollContext<InputStream, HttpResponseAttributes>>(this.connection, this.config, this, String.valueOf(Instant.now().getEpochSecond()), this.query);
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void poll(PollContext<InputStream, HttpResponseAttributes> pollContext) {
        this.processor.poll(pollContext, pollContext.getWatermark().orElse(null));
    }

    @Override
    public void onConnectionException(PollContext<InputStream, HttpResponseAttributes> context, ConnectionException exception) {
        context.onConnectionException(exception);
    }

    @Override
    public void accept(PollContext<InputStream, HttpResponseAttributes> context, GmailMessage gmailMessage, GmailWatermark watermark, Optional<HttpResponseAttributes> httpResponseAttributes) {
        PollContext.PollItemStatus itemStatus = context.accept(pollItem -> {
            Message message = Message.from(gmailMessage);
            try {
                byte[] payload = this.config.getObjectMapper().writeValueAsBytes((Object)message);
                Result itemResult = Result.builder().output((Object)new ByteArrayInputStream(payload)).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON).attributes((Object)httpResponseAttributes.orElse(null)).build();
                pollItem.setResult(itemResult);
                pollItem.setId(gmailMessage.getId());
                pollItem.setWatermark((Serializable)watermark);
            }
            catch (JsonProcessingException e) {
                logger.warn("Trigger '{}': Exception while serializing MuleMessage into bytes in poll consumer: '{}'", new Object[]{this.getId(), e.getMessage(), e});
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("Item {} {} processing result - {}", new Object[]{gmailMessage.getId(), gmailMessage.getInternalDate(), itemStatus.name()});
        }
    }

    public void onRejectedItem(Result<InputStream, HttpResponseAttributes> result, SourceCallbackContext sourceCallbackContext) {
        this.processor.handleRejectItem((InputStream)result.getOutput());
    }

    @Override
    public String getId() {
        return this.getClass().getSimpleName();
    }

    @Override
    public HttpRequest createHttpRequest(HttpRequestBuilder builder) {
        return builder.addQueryParam("fields", "id,internalDate,payload(mimeType,filename,headers,body,parts)").build();
    }
}

