/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.source.sidecar.sampledata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.error.RequestException;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.gmailconnectormule4.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.internal.config.GmailConfiguration;
import com.mulesoft.connectors.internal.source.Message;
import com.mulesoft.connectors.internal.source.dto.GmailMessage;
import com.mulesoft.connectors.internal.source.dto.GmailMessageId;
import com.mulesoft.connectors.internal.source.dto.ListGmailMessagesResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;

public class TriggerMessageSampleDataProvider
implements SampleDataProvider<InputStream, HttpResponseAttributes> {
    private static final String MESSAGES_PATH = "/gmail/v1/users/me/messages";
    private static final String MESSAGE_ID_PATH = "/gmail/v1/users/me/messages/%s";
    @Connection
    private RestConnection connection;
    @Config
    private GmailConfiguration config;

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public Result<InputStream, HttpResponseAttributes> getSample() throws SampleDataException {
        try {
            ObjectMapper objectMapper = this.config.getObjectMapper();
            String listMessagesPayload = (String)RequestStreamingUtils.doRequestAndConsumeString(this.connection, this.config, TriggerMessageSampleDataProvider.getMessagesRestRequestBuilder(this.connection), MediaType.APPLICATION_JSON).getOutput();
            String lastEmailId = Optional.ofNullable(((ListGmailMessagesResponse)objectMapper.readValue(listMessagesPayload, ListGmailMessagesResponse.class)).getMessages()).map(messages -> (GmailMessageId)messages.get(0)).map(GmailMessageId::getId).orElseThrow(() -> new SampleDataException("Failed to get sample data, no messages in inbox.", "CONNECTION_FAILURE"));
            org.mule.runtime.extension.api.runtime.operation.Result<String, HttpResponseAttributes> messagePayload = RequestStreamingUtils.doRequestAndConsumeString(this.connection, this.config, TriggerMessageSampleDataProvider.getMessageIdRestRequestBuilder(this.connection, lastEmailId), MediaType.APPLICATION_JSON);
            return Result.builder().output((Object)new ByteArrayInputStream(objectMapper.writeValueAsBytes((Object)Message.from((GmailMessage)objectMapper.readValue((String)messagePayload.getOutput(), GmailMessage.class))))).mediaType(MediaType.APPLICATION_JSON).attributes((Object)messagePayload.getAttributes().orElse(null)).build();
        }
        catch (RequestException e) {
            throw new SampleDataException("Failed to get sample data", "CONNECTION_FAILURE", (Throwable)((Object)e));
        }
        catch (JsonProcessingException e) {
            throw new SampleDataException("Failed to process json output while resolving sample data.", "CONNECTION_FAILURE", (Throwable)e);
        }
    }

    public static RestRequestBuilder getMessagesRestRequestBuilder(RestConnection connection) {
        return new RestRequestBuilder(connection.getBaseUri(), MESSAGES_PATH, HttpConstants.Method.GET, new EntityRequestParameters()).addHeader("accept", "application/json");
    }

    public static RestRequestBuilder getMessageIdRestRequestBuilder(RestConnection connection, String messageId) {
        return new RestRequestBuilder(connection.getBaseUri(), String.format(MESSAGE_ID_PATH, messageId), HttpConstants.Method.GET, new EntityRequestParameters()).addHeader("accept", "application/json");
    }

    @VisibleForTesting
    public void setConnection(RestConnection connection) {
        this.connection = connection;
    }

    @VisibleForTesting
    public void setConfig(GmailConfiguration config) {
        this.config = config;
    }
}

