/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.multipart.MultipartPayloadBuilder;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.multipart.DWMultipartPayloadBuilder;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.CloserCompletionCallbackDecorator;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import java.io.Closeable;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public abstract class BaseRestOperation {
    @Inject
    private ExpressionLanguage expressionLanguage;

    protected void doRequest(RestConfiguration config, RestConnection connection, RestRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        try {
            connection.request(builder, responseTimeoutMillis, this.resolveDefaultResponseMediaType(config), streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Throwable t) {
            callback.error(t);
        }
    }

    protected MediaType resolveDefaultResponseMediaType(RestConfiguration config) {
        MediaType mediaType = this.getDefaultResponseMediaType();
        if (!mediaType.getCharset().isPresent()) {
            mediaType = mediaType.withCharset(config.getCharset());
        }
        return mediaType;
    }

    protected void doVoidRequest(RestConnection connection, RestRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<String, HttpResponseAttributes> callback) {
        try {
            connection.bodylessRequest(builder, responseTimeoutMillis, MediaType.ANY, streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Throwable t) {
            callback.error(t);
        }
    }

    private <T> BiConsumer<Result<T, HttpResponseAttributes>, Throwable> handleResponse(CompletionCallback<T, HttpResponseAttributes> callback) {
        return (r, e) -> {
            if (e != null) {
                callback.error(e);
            } else {
                callback.success(r);
            }
        };
    }

    protected <T, A> void withMultipart(Consumer<MultipartPayloadBuilder> builderConfigurer, CompletionCallback<T, A> callback, BiConsumer<TypedValue<InputStream>, CompletionCallback<T, A>> consumer) {
        DWMultipartPayloadBuilder builder = new DWMultipartPayloadBuilder(this.expressionLanguage);
        builderConfigurer.accept(builder);
        TypedValue<InputStream> multipart = builder.build();
        try {
            consumer.accept(multipart, new CloserCompletionCallbackDecorator<T, A>(callback, (Closeable)multipart.getValue()));
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)((Closeable)multipart.getValue()));
            callback.error((Throwable)e);
        }
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

