/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestSdkUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public abstract class RestPagingProvider
implements PagingProvider<RestConnection, TypedValue<String>> {
    protected final ExpressionLanguage expressionLanguage;
    protected final int responseTimeout;
    protected final MediaType defaultMediaType;
    private final Function<RestConnection, RestRequestBuilder> requestFactory;
    private final StreamingHelper streamingHelper;
    private final String payloadExpression;
    private boolean stopPaging = false;

    public RestPagingProvider(Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper, String payloadExpression, MediaType defaultMediaType, int responseTimeout) {
        this.requestFactory = requestFactory;
        this.streamingHelper = streamingHelper;
        this.expressionLanguage = expressionLanguage;
        this.responseTimeout = responseTimeout;
        this.payloadExpression = payloadExpression;
        this.defaultMediaType = defaultMediaType;
    }

    protected abstract void configureRequest(RestRequestBuilder var1);

    public final List<TypedValue<String>> getPage(RestConnection connection) {
        Result<InputStream, HttpResponseAttributes> result;
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        RestRequestBuilder requestBuilder = this.requestFactory.apply(connection);
        this.configureRequest(requestBuilder);
        try {
            result = connection.request(requestBuilder, this.responseTimeout, this.defaultMediaType, this.streamingHelper).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)cause.getMessage()), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
        TypedValue<String> rawPage = RestSdkUtils.consumeStringAndClose(result.getOutput(), result.getMediaType().orElse(this.defaultMediaType), RestSdkUtils.resolveCharset(result.getMediaType(), this.defaultMediaType));
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        List<Object> page = RestSdkUtils.isBlank((CharSequence)rawPage.getValue()) ? Collections.emptyList() : this.extractPayload(rawPage);
        this.onPage(page, rawPage, result.getAttributes().orElse(null));
        return page;
    }

    public Optional<Integer> getTotalResults(RestConnection connection) {
        return Optional.empty();
    }

    public final void close(RestConnection connection) throws MuleException {
        this.doClose(connection);
    }

    protected void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, HttpResponseAttributes responseAttributes) {
    }

    protected void stopPaging() {
        this.stopPaging = true;
    }

    protected void doClose(RestConnection connection) throws MuleException {
    }

    protected <T> TypedValue<T> evaluate(TypedValue<String> content, String expression, DataType expectedOutputType, HttpResponseAttributes httpResponseAttributes) {
        return this.expressionLanguage.evaluate(expression, expectedOutputType, this.toBindingContext(content, httpResponseAttributes));
    }

    private List<TypedValue<String>> extractPayload(TypedValue<String> content) {
        TypedValue payload = this.expressionLanguage.evaluate(this.payloadExpression, content.getDataType(), this.toBindingContext(content));
        Iterator it = this.expressionLanguage.split("#[payload default []]", this.toBindingContext(payload));
        return RestSdkUtils.toList(it, content.getDataType().getMediaType(), this.defaultMediaType);
    }

    private BindingContext toBindingContext(TypedValue<?> content) {
        return this.toBindingContext(content, null);
    }

    private BindingContext toBindingContext(TypedValue<?> content, HttpResponseAttributes httpResponseAttributes) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", content);
        if (httpResponseAttributes != null) {
            builder.addBinding("attributes", TypedValue.of((Object)httpResponseAttributes));
        }
        return builder.build();
    }
}

