/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.builder.dataexpressions;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.builder.dataexpressions.DataExpressionBuilder;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.builder.dataexpressions.DataExpressionBuilders;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.dataexpressions.SequenceCompositeDataExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SequenceCompositeDataExpressionBuilder
implements DataExpressionBuilder<SequenceCompositeDataExpression> {
    private final List<StepBuilder> stepBuilders = new ArrayList<StepBuilder>();

    public SequenceCompositeDataExpressionBuilder step(String name, Consumer<StepBuilder> consumer) {
        StepBuilder stepBuilder = new StepBuilder(name);
        consumer.accept(stepBuilder);
        this.stepBuilders.add(stepBuilder);
        return this;
    }

    public SequenceCompositeDataExpressionBuilder step(Consumer<StepBuilder> consumer) {
        return this.step(null, consumer);
    }

    private List<SequenceCompositeDataExpression.Step> buildSteps() {
        return this.stepBuilders.stream().map(StepBuilder::build).collect(Collectors.toList());
    }

    @Override
    public SequenceCompositeDataExpression build() {
        return new SequenceCompositeDataExpression(this.buildSteps());
    }

    public static class StepBuilder {
        private final String name;
        private DataExpressionBuilders dataExpressionBuilders;
        private DataExpression dataExpression;

        public StepBuilder(String name) {
            this.name = name;
        }

        public StepBuilder dataExpression(Consumer<DataExpressionBuilders> consumer) {
            this.dataExpressionBuilders = new DataExpressionBuilders();
            consumer.accept(this.dataExpressionBuilders);
            return this;
        }

        public StepBuilder withDataExpression(DataExpression dataExpression) {
            this.dataExpression = dataExpression;
            return this;
        }

        private Optional<String> buildName() {
            return Optional.ofNullable(this.name);
        }

        private DataExpression buildDataExpression() {
            if (this.dataExpressionBuilders != null && this.dataExpression != null) {
                throw new IllegalStateException("Both consumer and expression set");
            }
            if (this.dataExpressionBuilders == null && this.dataExpression == null) {
                throw new IllegalStateException("No consumer or expression set");
            }
            if (this.dataExpressionBuilders != null) {
                return this.dataExpressionBuilders.build();
            }
            return this.dataExpression;
        }

        public SequenceCompositeDataExpression.Step build() {
            return new SequenceCompositeDataExpression.Step(this.buildName().orElse(null), this.buildDataExpression());
        }
    }
}

