/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.builder.resolvers;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.builder.resolvers.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.builder.resolvers.ResolverParameterBuilder;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.resolvers.ResolverDeclaration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.resolvers.ResolverDefinition;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.model.resolvers.ResolverParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class ResolverDeclarationBuilder<T extends ResolverDefinitionBuilder<U>, U extends ResolverDefinition> {
    protected final String name;
    protected List<ResolverParameterBuilder> parameters;
    protected T definitionBuilder;

    public ResolverDeclarationBuilder(String name, T definitionBuilder) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.definitionBuilder = definitionBuilder;
        this.parameters = new ArrayList<ResolverParameterBuilder>();
    }

    public ResolverDeclarationBuilder<T, U> definition(Consumer<T> resolverDefinitionBuilderConsumer) {
        resolverDefinitionBuilderConsumer.accept(this.definitionBuilder);
        return this;
    }

    public ResolverDeclaration<U> build() {
        return new ResolverDeclaration<U>(this.getName(), this.buildParameters(), this.buildDefinition());
    }

    public ResolverDeclarationBuilder<T, U> parameter(String name, Consumer<ResolverParameterBuilder> resolverParameterBuilderConsumer) {
        ResolverParameterBuilder resolverParameterBuilder = new ResolverParameterBuilder(name);
        resolverParameterBuilderConsumer.accept(resolverParameterBuilder);
        this.parameters.add(resolverParameterBuilder);
        return this;
    }

    protected U buildDefinition() {
        if (this.definitionBuilder == null) {
            throw new IllegalArgumentException();
        }
        return (U)((ResolverDefinitionBuilder)this.definitionBuilder).build();
    }

    protected List<ResolverParameter> buildParameters() {
        return this.parameters.stream().map(ResolverParameterBuilder::build).collect(Collectors.toList());
    }

    protected String getName() {
        return this.name;
    }
}

