/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.googlecalendar.internal.metadata.CreateCalendarsAclWatchByCalendarIdInputMetadataResolver;
import com.mulesoft.connectors.googlecalendar.internal.metadata.CreateCalendarsAclWatchByCalendarIdOutputMetadataResolver;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class CreateCalendarsAclWatchByCalendarIdOperation
extends BaseRestOperation {
    private static final Pattern CALENDAR_ID_PATTERN = Pattern.compile("\\{calendarId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Acl watch")
    @Summary(value="Watch for changes to ACL resources.")
    @MediaType(value="application/json")
    @OutputResolver(output=CreateCalendarsAclWatchByCalendarIdOutputMetadataResolver.class)
    public void createCalendarsAclWatchByCalendarId(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Calendar Id") @Summary(value="Calendar identifier. To retrieve calendar IDs call the calendarList.list method.") String calendarId, @Optional @DisplayName(value="Max Results") @Summary(value="Maximum number of entries returned on one result page. By default the value is 100 entries.") Integer maxResults, @Optional @DisplayName(value="Pretty Print") @Summary(value="Returns response with indentations and line breaks.") boolean prettyPrint, @Optional @DisplayName(value="Page Token") @Summary(value="Token specifying which result page to return. Optional.") String pageToken, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @Optional @DisplayName(value="Show Deleted") @Summary(value="Whether to include deleted ACLs in the result. Deleted ACLs are represented by role equal to \"none\".") boolean showDeleted, @Optional @DisplayName(value="fields") @Summary(value="Selector specifying which fields to include in a partial response. If empty, all fields will be returned.") String fields, @Optional @DisplayName(value="Sync Token") @Summary(value="Token obtained from the nextSyncToken field returned on the last page of results from the previous list request.") String syncToken, @Content(primary=true) @TypeResolver(value=CreateCalendarsAclWatchByCalendarIdInputMetadataResolver.class) TypedValue<InputStream> channelRequestContent, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/calendars/{calendarId}/acl/watch";
        requestPath = CALENDAR_ID_PATTERN.matcher(requestPath).replaceAll(calendarId);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.POST, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("content-type", "application/json").addHeader("accept", "application/json").addQueryParam("maxResults", maxResults != null ? String.valueOf(maxResults) : null).addQueryParam("prettyPrint", String.valueOf(prettyPrint)).addQueryParam("pageToken", pageToken).addQueryParam("quotaUser", quotaUser).addQueryParam("showDeleted", String.valueOf(showDeleted)).addQueryParam("fields", fields).addQueryParam("syncToken", syncToken).setBody(channelRequestContent, overrides.getStreamingType());
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

