/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.googlecalendar.api.metadata.SendUpdatesEnum;
import com.mulesoft.connectors.googlecalendar.internal.metadata.CreateCalendarsEventsByCalendarIdInputMetadataResolver;
import com.mulesoft.connectors.googlecalendar.internal.metadata.CreateCalendarsEventsByCalendarIdOutputMetadataResolver;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class CreateCalendarsEventsByCalendarIdOperation
extends BaseRestOperation {
    private static final Pattern CALENDAR_ID_PATTERN = Pattern.compile("\\{calendarId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Events insert")
    @Summary(value="Creates an event.")
    @MediaType(value="application/json")
    @OutputResolver(output=CreateCalendarsEventsByCalendarIdOutputMetadataResolver.class)
    public void createCalendarsEventsByCalendarId(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Calendar Id") @Summary(value="Calendar identifier. To retrieve calendar IDs call the calendarList.list method.") String calendarId, @Optional @DisplayName(value="Send Updates") @Summary(value="Whether to send notifications about the creation of the new event. Note that some emails might still be sent.") SendUpdatesEnum sendUpdates, @Optional @DisplayName(value="Pretty Print") @Summary(value="Returns response with indentations and line breaks.") boolean prettyPrint, @Optional @DisplayName(value="Conference Data Version") @Summary(value="Version number of conference data supported by the API client.") Integer conferenceDataVersion, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @Optional @DisplayName(value="Supports Attachments") @Summary(value="Whether API client performing operation supports event attachments. Optional. The default is False.") boolean supportsAttachments, @Optional @DisplayName(value="Max Attendees") @Summary(value="The maximum number of attendees to include in the response.") Integer maxAttendees, @Optional @DisplayName(value="fields") @Summary(value="Selector specifying which fields to include in a partial response. If empty, all fields will be returned.") String fields, @Content(primary=true) @TypeResolver(value=CreateCalendarsEventsByCalendarIdInputMetadataResolver.class) TypedValue<InputStream> eventRequestInsertContent, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/calendars/{calendarId}/events";
        requestPath = CALENDAR_ID_PATTERN.matcher(requestPath).replaceAll(calendarId);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.POST, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("content-type", "application/json").addHeader("accept", "application/json").addQueryParam("sendUpdates", sendUpdates != null ? sendUpdates.getValue() : null).addQueryParam("prettyPrint", String.valueOf(prettyPrint)).addQueryParam("conferenceDataVersion", conferenceDataVersion != null ? String.valueOf(conferenceDataVersion) : null).addQueryParam("quotaUser", quotaUser).addQueryParam("supportsAttachments", String.valueOf(supportsAttachments)).addQueryParam("maxAttendees", maxAttendees != null ? String.valueOf(maxAttendees) : null).addQueryParam("fields", fields).setBody(eventRequestInsertContent, overrides.getStreamingType());
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

