/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.googlecalendar.api.metadata.OrderByEnum;
import com.mulesoft.connectors.googlecalendar.internal.metadata.CreateCalendarsEventsWatchByCalendarIdInputMetadataResolver;
import com.mulesoft.connectors.googlecalendar.internal.metadata.CreateCalendarsEventsWatchByCalendarIdOutputMetadataResolver;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class CreateCalendarsEventsWatchByCalendarIdOperation
extends BaseRestOperation {
    private static final Pattern CALENDAR_ID_PATTERN = Pattern.compile("\\{calendarId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Events watch")
    @Summary(value="Watch for changes to Events resources.")
    @MediaType(value="application/json")
    @OutputResolver(output=CreateCalendarsEventsWatchByCalendarIdOutputMetadataResolver.class)
    public void createCalendarsEventsWatchByCalendarId(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Calendar Id") @Summary(value="Calendar identifier. To retrieve calendar IDs call the calendarList.list method.") String calendarId, @Optional @DisplayName(value="Time Min") @Summary(value="Lower bound (exclusive) for an event''s end time to filter by. Optional. The default is not to filter by end time.") String timeMin, @Optional @DisplayName(value="iCalUID") @Summary(value="Specifies event ID in the iCalendar format to be included in the response. Optional.") String iCalUid, @Optional @NullSafe @DisplayName(value="Private Extended Property") @Summary(value="Extended properties constraint specified as propertyName=value. Matches only private properties.") List<String> privateExtendedProperties, @Optional @DisplayName(value="Show Hidden Invitations") @Summary(value="Whether to include hidden invitations in the result. Optional. The default is False.") boolean showHiddenInvitations, @Optional @DisplayName(value="Max Results") @Summary(value="Maximum number of events returned on one result page.") Integer maxResults, @Optional @NullSafe @DisplayName(value="Shared Extended Property") @Summary(value="Extended properties constraint specified as propertyName=value. Matches only shared properties.") List<String> sharedExtendedProperties, @Optional @DisplayName(value="Pretty Print") @Summary(value="Returns response with indentations and line breaks.") boolean prettyPrint, @Optional @DisplayName(value="Page Token") @Summary(value="Token specifying which result page to return. Optional.") String pageToken, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @Optional @DisplayName(value="Updated Min") @Summary(value="Lower bound for an event''s last modification time (as a RFC3339 timestamp) to filter by.") String updatedMin, @Optional @DisplayName(value="Show Deleted") @Summary(value="Whether to include deleted events (with status equals \"cancelled\") in the result.") boolean showDeleted, @Optional @DisplayName(value="Max Attendees") @Summary(value="The maximum number of attendees to include in the response.") Integer maxAttendees, @Optional @DisplayName(value="q") @Summary(value="Free text search terms to find events that match these terms in any field, except for extended properties. Optional.") String q, @Optional @DisplayName(value="Single Events") @Summary(value="Whether to expand recurring events into instances and only return single one-off events and instances of recurring events, bu...") boolean singleEvents, @Optional @DisplayName(value="fields") @Summary(value="Selector specifying which fields to include in a partial response. If empty, all fields will be returned.") String fields, @Optional @DisplayName(value="Order By") @Summary(value="The order of the events returned in the result. Optional. The default is an unspecified, stable order.") OrderByEnum orderBy, @Optional @DisplayName(value="Sync Token") @Summary(value="Token obtained from the nextSyncToken field returned on the last page of results from the previous list request.") String syncToken, @Optional @DisplayName(value="Time Zone") @Summary(value="Time zone used in the response. Optional. The default is the time zone of the calendar.") String timeZone, @Optional @DisplayName(value="Time Max") @Summary(value="Upper bound (exclusive) for an event''s start time to filter by. Optional. The default is not to filter by start time.") String timeMax, @Content(primary=true) @TypeResolver(value=CreateCalendarsEventsWatchByCalendarIdInputMetadataResolver.class) TypedValue<InputStream> channelRequestContent, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/calendars/{calendarId}/events/watch";
        requestPath = CALENDAR_ID_PATTERN.matcher(requestPath).replaceAll(calendarId);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.POST, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("content-type", "application/json").addHeader("accept", "application/json").addQueryParam("timeMin", timeMin).addQueryParam("iCalUID", iCalUid).addQueryParams("privateExtendedProperty", privateExtendedProperties.stream().filter(Objects::nonNull).collect(Collectors.toList())).addQueryParam("showHiddenInvitations", String.valueOf(showHiddenInvitations)).addQueryParam("maxResults", maxResults != null ? String.valueOf(maxResults) : null).addQueryParams("sharedExtendedProperty", sharedExtendedProperties.stream().filter(Objects::nonNull).collect(Collectors.toList())).addQueryParam("prettyPrint", String.valueOf(prettyPrint)).addQueryParam("pageToken", pageToken).addQueryParam("quotaUser", quotaUser).addQueryParam("updatedMin", updatedMin).addQueryParam("showDeleted", String.valueOf(showDeleted)).addQueryParam("maxAttendees", maxAttendees != null ? String.valueOf(maxAttendees) : null).addQueryParam("q", q).addQueryParam("singleEvents", String.valueOf(singleEvents)).addQueryParam("fields", fields).addQueryParam("orderBy", orderBy != null ? orderBy.getValue() : null).addQueryParam("syncToken", syncToken).addQueryParam("timeZone", timeZone).addQueryParam("timeMax", timeMax).setBody(channelRequestContent, overrides.getStreamingType());
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

