/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import java.util.regex.Pattern;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class DeleteCalendarsByCalendarIdOperation
extends BaseRestOperation {
    private static final Pattern CALENDAR_ID_PATTERN = Pattern.compile("\\{calendarId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Calendars delete")
    @Summary(value="Deletes a secondary calendar. Use calendars.clear for clearing all events on primary calendars.")
    @MediaType(value="text/plain")
    public void deleteCalendarsByCalendarId(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Calendar Id") @Summary(value="Calendar identifier. To retrieve calendar IDs call the calendarList.list method.") String calendarId, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<String, HttpResponseAttributes> callback) {
        String requestPath = "/calendars/{calendarId}";
        requestPath = CALENDAR_ID_PATTERN.matcher(requestPath).replaceAll(calendarId);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.DELETE, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addQueryParam("quotaUser", quotaUser);
        this.doVoidRequest(connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

