/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.googlecalendar.internal.metadata.GetCalendarsEventsByCalendarIdEventIdOutputMetadataResolver;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GetCalendarsEventsByCalendarIdEventIdOperation
extends BaseRestOperation {
    private static final Pattern CALENDAR_ID_PATTERN = Pattern.compile("\\{calendarId}");
    private static final Pattern EVENT_ID_PATTERN = Pattern.compile("\\{eventId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Events get")
    @Summary(value="Returns an event.")
    @MediaType(value="application/json")
    @OutputResolver(output=GetCalendarsEventsByCalendarIdEventIdOutputMetadataResolver.class)
    public void getCalendarsEventsByCalendarIdEventId(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Calendar Id") @Summary(value="Calendar identifier. To retrieve calendar IDs call the calendarList.list method.") String calendarId, @DisplayName(value="Event Id") @Summary(value="Event identifier.") String eventId, @Optional @DisplayName(value="Pretty Print") @Summary(value="Returns response with indentations and line breaks.") boolean prettyPrint, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @Optional @DisplayName(value="Max Attendees") @Summary(value="The maximum number of attendees to include in the response.") Integer maxAttendees, @Optional @DisplayName(value="fields") @Summary(value="Selector specifying which fields to include in a partial response. If empty, all fields will be returned.") String fields, @Optional @DisplayName(value="Time Zone") @Summary(value="Time zone used in the response. Optional. The default is the time zone of the calendar.") String timeZone, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/calendars/{calendarId}/events/{eventId}";
        requestPath = CALENDAR_ID_PATTERN.matcher(requestPath).replaceAll(calendarId);
        requestPath = EVENT_ID_PATTERN.matcher(requestPath).replaceAll(eventId);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("prettyPrint", String.valueOf(prettyPrint)).addQueryParam("quotaUser", quotaUser).addQueryParam("maxAttendees", maxAttendees != null ? String.valueOf(maxAttendees) : null).addQueryParam("fields", fields).addQueryParam("timeZone", timeZone);
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

