/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.paging.MarkerPagingProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.googlecalendar.api.metadata.OrderByEnum;
import com.mulesoft.connectors.googlecalendar.internal.metadata.GetCalendarsEventsByCalendarIdPagingMetadataResolver;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GetCalendarsEventsByCalendarIdOperation
extends BaseRestOperation {
    private static final Pattern CALENDAR_ID_PATTERN = Pattern.compile("\\{calendarId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;
    @Inject
    private ExpressionLanguage expressionLanguage;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Events list")
    @Summary(value="Returns events on the specified calendar.")
    @OutputResolver(output=GetCalendarsEventsByCalendarIdPagingMetadataResolver.class)
    public PagingProvider<RestConnection, TypedValue<String>> getCalendarsEventsByCalendarId(@Config RestConfiguration config, @DisplayName(value="Calendar Id") @Summary(value="Calendar identifier. To retrieve calendar IDs call the calendarList.list method.") String calendarId, @Optional @DisplayName(value="Time Min") @Summary(value="Lower bound (exclusive) for an event''s end time to filter by. Optional. The default is not to filter by end time.") String timeMin, @Optional @DisplayName(value="iCalUID") @Summary(value="Specifies event ID in the iCalendar format to be included in the response. Optional.") String iCalUid, @Optional @NullSafe @DisplayName(value="Private Extended Property") @Summary(value="Extended properties constraint specified as propertyName=value. Matches only private properties.") List<String> privateExtendedProperties, @Optional @DisplayName(value="Show Hidden Invitations") @Summary(value="Whether to include hidden invitations in the result. Optional. The default is False.") boolean showHiddenInvitations, @Optional @NullSafe @DisplayName(value="Shared Extended Property") @Summary(value="Extended properties constraint specified as propertyName=value. Matches only shared properties.") List<String> sharedExtendedProperties, @Optional @DisplayName(value="Pretty Print") @Summary(value="Returns response with indentations and line breaks.") boolean prettyPrint, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @Optional @DisplayName(value="Updated Min") @Summary(value="Lower bound for an event''s last modification time (as a RFC3339 timestamp) to filter by.") String updatedMin, @Optional @DisplayName(value="Show Deleted") @Summary(value="Whether to include deleted events (with status equals \"cancelled\") in the result.") boolean showDeleted, @Optional @DisplayName(value="Max Attendees") @Summary(value="The maximum number of attendees to include in the response.") Integer maxAttendees, @Optional @DisplayName(value="q") @Summary(value="Free text search terms to find events that match these terms in any field, except for extended properties. Optional.") String q, @Optional @DisplayName(value="Single Events") @Summary(value="Whether to expand recurring events into instances and only return single one-off events and instances of recurring events, bu...") boolean singleEvents, @Optional @DisplayName(value="fields") @Summary(value="Selector specifying which fields from items to include in a partial response. If empty, all fields will be returned.") String fields, @Optional @DisplayName(value="Order By") @Summary(value="The order of the events returned in the result. Optional. The default is an unspecified, stable order.") OrderByEnum orderBy, @Optional @DisplayName(value="Time Zone") @Summary(value="Time zone used in the response. Optional. The default is the time zone of the calendar.") String timeZone, @Optional @DisplayName(value="Time Max") @Summary(value="Upper bound (exclusive) for an event''s start time to filter by. Optional. The default is not to filter by start time.") String timeMax, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper) {
        Function<RestConnection, RestRequestBuilder> requestFactory = connection -> {
            String requestPath = "/calendars/{calendarId}/events";
            requestPath = CALENDAR_ID_PATTERN.matcher(requestPath).replaceAll(calendarId);
            RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("timeMin", timeMin).addQueryParam("iCalUID", iCalUid).addQueryParams("privateExtendedProperty", privateExtendedProperties.stream().filter(Objects::nonNull).collect(Collectors.toList())).addQueryParam("showHiddenInvitations", String.valueOf(showHiddenInvitations)).addQueryParams("sharedExtendedProperty", sharedExtendedProperties.stream().filter(Objects::nonNull).collect(Collectors.toList())).addQueryParam("prettyPrint", String.valueOf(prettyPrint)).addQueryParam("quotaUser", quotaUser).addQueryParam("updatedMin", updatedMin).addQueryParam("showDeleted", String.valueOf(showDeleted)).addQueryParam("maxAttendees", maxAttendees != null ? String.valueOf(maxAttendees) : null).addQueryParam("q", q).addQueryParam("singleEvents", String.valueOf(singleEvents)).addQueryParam("fields", fields).addQueryParam("orderBy", orderBy != null ? orderBy.getValue() : null).addQueryParam("timeZone", timeZone).addQueryParam("timeMax", timeMax);
            return builder;
        };
        return new MarkerPagingProvider("pageToken", "#[payload.nextPageToken]", requestFactory, this.expressionLanguage, streamingHelper, "#[payload.items]", this.resolveDefaultResponseMediaType(config), overrides.getResponseTimeoutAsMillis());
    }
}

