/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.paging.MarkerPagingProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.googlecalendar.api.metadata.MinAccessRoleEnum;
import com.mulesoft.connectors.googlecalendar.internal.metadata.GetUsersMeCalendarListPagingMetadataResolver;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GetUsersMeCalendarListOperation
extends BaseRestOperation {
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;
    @Inject
    private ExpressionLanguage expressionLanguage;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Calendar List list")
    @Summary(value="Returns the calendars on the user''s calendar list.")
    @OutputResolver(output=GetUsersMeCalendarListPagingMetadataResolver.class)
    public PagingProvider<RestConnection, TypedValue<String>> getUsersMeCalendarList(@Config RestConfiguration config, @Optional @DisplayName(value="Pretty Print") @Summary(value="Returns response with indentations and line breaks.") boolean prettyPrint, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @Optional @DisplayName(value="Show Deleted") @Summary(value="Whether to include deleted calendar list entries in the result. Optional. The default is False.") boolean showDeleted, @Optional @DisplayName(value="fields") @Summary(value="Selector specifying which fields from items to include in a partial response. If empty, all fields will be returned.") String fields, @Optional @DisplayName(value="Min Access Role") @Summary(value="The minimum access role for the user in the returned entries. Optional. The default is no restriction.") MinAccessRoleEnum minAccessRole, @Optional @DisplayName(value="Show Hidden") @Summary(value="Whether to show hidden entries. Optional. The default is False.") boolean showHidden, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper) {
        Function<RestConnection, RestRequestBuilder> requestFactory = connection -> {
            String requestPath = "/users/me/calendarList";
            RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("prettyPrint", String.valueOf(prettyPrint)).addQueryParam("quotaUser", quotaUser).addQueryParam("showDeleted", String.valueOf(showDeleted)).addQueryParam("fields", fields).addQueryParam("minAccessRole", minAccessRole != null ? minAccessRole.getValue() : null).addQueryParam("showHidden", String.valueOf(showHidden));
            return builder;
        };
        return new MarkerPagingProvider("pageToken", "#[payload.nextPageToken]", requestFactory, this.expressionLanguage, streamingHelper, "#[payload.items]", this.resolveDefaultResponseMediaType(config), overrides.getResponseTimeoutAsMillis());
    }
}

