/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.googlecalendar.internal.metadata.UpdateCalendarsAclByCalendarIdRuleIdInputMetadataResolver;
import com.mulesoft.connectors.googlecalendar.internal.metadata.UpdateCalendarsAclByCalendarIdRuleIdOutputMetadataResolver;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class UpdateCalendarsAclByCalendarIdRuleIdOperation
extends BaseRestOperation {
    private static final Pattern CALENDAR_ID_PATTERN = Pattern.compile("\\{calendarId}");
    private static final Pattern RULE_ID_PATTERN = Pattern.compile("\\{ruleId}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Acl update")
    @Summary(value="Updates an access control rule.")
    @MediaType(value="application/json")
    @OutputResolver(output=UpdateCalendarsAclByCalendarIdRuleIdOutputMetadataResolver.class)
    public void updateCalendarsAclByCalendarIdRuleId(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Calendar Id") @Summary(value="Calendar identifier. To retrieve calendar IDs call the calendarList.list method.") String calendarId, @DisplayName(value="Rule Id") @Summary(value="ACL rule identifier.") String ruleId, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @Optional @DisplayName(value="fields") @Summary(value="Selector specifying which fields to include in a partial response. If empty, all fields will be returned.") String fields, @Optional @DisplayName(value="Pretty Print") @Summary(value="Returns response with indentations and line breaks.") boolean prettyPrint, @Optional @DisplayName(value="Send Notifications") @Summary(value="Whether to send notifications about the calendar sharing change. Note that there are no notifications on access removal.") boolean sendNotifications, @Content(primary=true) @TypeResolver(value=UpdateCalendarsAclByCalendarIdRuleIdInputMetadataResolver.class) TypedValue<InputStream> aclRuleRequestContent, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/calendars/{calendarId}/acl/{ruleId}";
        requestPath = CALENDAR_ID_PATTERN.matcher(requestPath).replaceAll(calendarId);
        requestPath = RULE_ID_PATTERN.matcher(requestPath).replaceAll(ruleId);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.PUT, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("content-type", "application/json").addHeader("accept", "application/json").addQueryParam("quotaUser", quotaUser).addQueryParam("fields", fields).addQueryParam("prettyPrint", String.valueOf(prettyPrint)).addQueryParam("sendNotifications", String.valueOf(sendNotifications)).setBody(aclRuleRequestContent, overrides.getStreamingType());
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

