/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation.sidecar;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectors.googlecalendar.api.metadata.SendUpdatesEnum;
import com.mulesoft.connectors.googlecalendar.internal.config.GoogleCalendarConfiguration;
import com.mulesoft.connectors.googlecalendar.internal.metadata.CreateCalendarsEventsByCalendarIdOutputMetadataResolver;
import com.mulesoft.connectors.googlecalendar.internal.operation.CreateCalendarsEventsByCalendarIdOperation;
import com.mulesoft.connectors.googlecalendar.internal.operation.sidecar.sampledata.CreateCalendarEventSampleDataProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public class CreateNewCalendarEventOperation
extends BaseRestOperation {
    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Create event")
    @Summary(value="Create an event in Google Calendar")
    @MediaType(value="application/json")
    @OutputResolver(output=CreateCalendarsEventsByCalendarIdOutputMetadataResolver.class)
    @SampleData(value=CreateCalendarEventSampleDataProvider.class)
    public void createNewCalendarEvent(@Config GoogleCalendarConfiguration config, @Connection RestConnection connection, @DisplayName(value="Calendar ID") @Summary(value="Calendar ID") String calendarId, @DisplayName(value="Start Time") @Summary(value="Defines the start time of an event") String startTime, @DisplayName(value="End Time") @Summary(value="Defines the end time of an event") String endTime, @Optional @DisplayName(value="Summary") @Summary(value="The summary of the event") String summary, @Optional @DisplayName(value="Description") @Summary(value="The description of the event") String description, @Optional @DisplayName(value="Location") @Summary(value="The location of the event") String location, @Optional @DisplayName(value="Attendee emails") @Summary(value="Emails of the attendees") List<String> attendeeEmails, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, final CompletionCallback<InputStream, Void> callback) {
        new CreateCalendarsEventsByCalendarIdOperation().createCalendarsEventsByCalendarId(config, connection, calendarId, SendUpdatesEnum.ALL, true, 1, "", true, attendeeEmails.size(), "", (TypedValue<InputStream>)new TypedValue((Object)new ByteArrayInputStream(Stream.of("startTime:" + startTime, "endTime:" + endTime, "summary:" + summary, "description:" + description).filter(StringUtils::isNotEmpty).collect(Collectors.joining(",\n", "{\n", "\n}")).getBytes()), DataType.JSON_STRING), parameters, overrides, streamingHelper, new CompletionCallback<InputStream, HttpResponseAttributes>(){

            public void success(Result<InputStream, HttpResponseAttributes> result) {
                callback.success(Result.builder().output(result.getOutput()).build());
            }

            public void error(Throwable err) {
                callback.error(err);
            }
        });
    }
}

