/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.operation.sidecar.sampledata;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RequestException;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.adapter.SdkResultAdapter;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.googlecalendar.internal.config.GoogleCalendarConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;

public class CreateCalendarEventSampleDataProvider
implements SampleDataProvider<InputStream, Void> {
    @Connection
    private RestConnection connection;
    @Config
    private GoogleCalendarConfiguration config;
    @Inject
    private ExpressionLanguage expressionLanguage;
    @Parameter
    private String calendarId;
    private static String DW_EXPRESSION = "%dw 2.0\noutput application/json\nvar event = payload.items[randomInt(sizeOf(payload.items)-1)]\n---\n{\n    id : event.id,\n    status : event.status,\n    created : event.created\n}";

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public Result<InputStream, Void> getSample() throws SampleDataException {
        try {
            BindingContext bindingContext;
            String requestPath = String.format("/calendar/v3/calendars/%s/events", this.calendarId);
            Result response = SdkResultAdapter.from(RequestStreamingUtils.doRequestAndConsumeString(this.connection, this.config, new RestRequestBuilder(this.connection.getBaseUri(), requestPath, HttpConstants.Method.GET, new EntityRequestParameters()).addHeader("accept", "application/json"), MediaType.APPLICATION_JSON));
            String singleEvent = (String)response.getOutput();
            if (DW_EXPRESSION != null && (singleEvent = this.expressionLanguage.evaluate(DW_EXPRESSION, bindingContext = BindingContext.builder().addBinding("payload", new TypedValue((Object)singleEvent, DataType.JSON_STRING)).build()).getValue().toString()) == null) {
                throw new SampleDataException("No data available", "NO_DATA_AVAILABLE");
            }
            return Result.builder().output((Object)new ByteArrayInputStream(singleEvent.getBytes())).build();
        }
        catch (RequestException e) {
            if (e.getType() == RestError.UNAUTHORIZED) {
                throw new AccessTokenExpiredException();
            }
            throw new SampleDataException("Failed to get sample data", "CONNECTION_FAILURE", (Throwable)((Object)e));
        }
    }
}

