/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.googlecalendar.internal.source;

import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.api.source.RequestParameterBinding;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.googlecalendarconnector.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectors.googlecalendar.internal.metadata.OnUpdatedEventsTriggerOutputMetadataResolver;
import com.mulesoft.connectors.googlecalendar.internal.source.AbstractPollingSource;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpConstants;

@MediaType(value="application/json")
@MetadataScope(outputResolver=OnUpdatedEventsTriggerOutputMetadataResolver.class)
public class OnUpdatedEventsTrigger
extends AbstractPollingSource {
    private static final String PATH_TEMPLATE = "/calendars/{calendarId}/events";
    private static final String ITEMS_EXPRESSION = "#[payload.items]";
    private static final String WATERMARK_EXPRESSION = "#[item.updated]";
    private static final String IDENTITY_EXPRESSION = "#[item.id]";
    private static final String REQUEST_BODY_EXPRESSION = null;
    @Parameter
    @DisplayName(value="Calendar Id")
    @Summary(value="Calendar identifier. To retrieve calendar IDs call the calendarList.list method.")
    String calendarId;
    @Parameter
    @DisplayName(value="Updated Min")
    @Summary(value="Lower bound for the last modification time of an event to filter by (as a RFC3339 timestamp).")
    @Optional
    String updatedMin;

    public OnUpdatedEventsTrigger() {
        super(ITEMS_EXPRESSION, WATERMARK_EXPRESSION, IDENTITY_EXPRESSION, REQUEST_BODY_EXPRESSION);
    }

    @Override
    protected DataType getWatermarkDataType() {
        return DataType.fromType(String.class);
    }

    @Override
    protected String getPathTemplate() {
        return PATH_TEMPLATE;
    }

    @Override
    protected RestRequestBuilder getRequestBuilder(String path) {
        return new RestRequestBuilder(this.connection.getBaseUri(), path, HttpConstants.Method.GET);
    }

    @Override
    protected RequestParameterBinding getParameterBinding() {
        RequestParameterBinding parameterBinding = new RequestParameterBinding();
        parameterBinding.addUriParamBinding("calendarId", "#[parameters.calendarId]");
        parameterBinding.addQueryParamBinding("updatedMin", "#[if(watermark == null) parameters.updatedMin else watermark + |PT0.001S|]");
        parameterBinding.addQueryParamBinding("orderBy", "updated");
        parameterBinding.addQueryParamBinding("showDeleted", "false");
        return parameterBinding;
    }

    @Override
    protected MultiMap<String, TypedValue<?>> getParameterValues() {
        MultiMap parameterValues = new MultiMap();
        parameterValues.put((Object)"calendarId", RestSdkUtils.getTypedValueOrNull(this.calendarId));
        parameterValues.put((Object)"updatedMin", RestSdkUtils.getTypedValueOrNull(this.updatedMin));
        return parameterValues;
    }

    @Override
    protected DataType getRequestBodyDataType() {
        return DataType.JSON_STRING;
    }
}

