/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.connection.provider;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class BatchProcessingParams {
    @Optional(defaultValue="10")
    @Parameter
    @DisplayName(value="Message Count Batch Size")
    @Summary(value="Maximum number of messages in the batch")
    @Placement(order=1, tab="Advanced")
    private long messageCountBatchSize;
    @Optional(defaultValue="1")
    @Parameter
    @DisplayName(value="Request Size Threshold")
    @Summary(value="Maximum memory size of the messages in batch.")
    @Placement(order=2, tab="Advanced")
    private long requestSizeThreshold;
    @Parameter
    @Optional(defaultValue="KB")
    @DisplayName(value="Request Size Threshold Unit")
    @Summary(value="A data unit that qualifies request size threshold")
    @Placement(order=3, tab="Advanced")
    private DataUnit requestSizeThresholdUnit;
    @Optional(defaultValue="10")
    @Parameter
    @DisplayName(value="Publish Delay Threshold")
    @Summary(value="Maximum delay threshold to use for batching.")
    @Placement(order=4, tab="Advanced")
    private long publishDelayThreshold;
    @Optional(defaultValue="MILLISECONDS")
    @Parameter
    @DisplayName(value="Publish Delay Threshold Time Unit")
    @Summary(value="Time Unit for delay between consecutive publish requests.")
    @Placement(order=5, tab="Advanced")
    private TimeUnit publishDelayThresholdTimeUnit;
    @Optional(defaultValue="false")
    @Parameter
    @DisplayName(value="Enable batching")
    @Summary(value="Flag for enabling/disabling publish requests batching.")
    @Placement(order=6, tab="Advanced")
    private boolean batchingEnabled;

    public long getMessageCountBatchSize() {
        return this.messageCountBatchSize;
    }

    public long getRequestSizeThresholdInBytes() {
        return this.requestSizeThresholdUnit.toBytes((int)this.requestSizeThreshold);
    }

    public long getPublishDelayThresholdInMillis() {
        return this.publishDelayThresholdTimeUnit.toMillis(this.publishDelayThreshold);
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }
}

