/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.connection.provider;

import com.mulesoft.connector.googlepubsub.internal.connection.provider.LimitExceededBehavior;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class FlowControlParameters {
    @Optional(defaultValue="BLOCK")
    @Parameter
    @DisplayName(value="Limit Exceeded Behavior")
    @Summary(value="The behavior of FlowController when the specified limits are exceeded")
    @Placement(tab="Advanced")
    private LimitExceededBehavior limitExceededBehavior;
    @Optional(defaultValue="100")
    @Parameter
    @DisplayName(value="Max Outstanding Request Size")
    @Summary(value="Maximum amount of memory accumulated by request before enforcing flow control")
    @Placement(tab="Advanced")
    private long maxOutstandingRequestSize;
    @Optional(defaultValue="MB")
    @Parameter
    @DisplayName(value="Max Outstanding Request Size Unit")
    @Summary(value="The data unit for max outstanding request size.")
    @Placement(tab="Advanced")
    private DataUnit maxOutstandingRequestSizeUnit;
    @Optional(defaultValue="100")
    @Parameter
    @DisplayName(value="Max Outstanding Element Count")
    @Summary(value="Maximum number of outstanding elements in memory before enforcing flow control")
    @Placement(tab="Advanced")
    private long maxOutstandingElementCount;

    public LimitExceededBehavior getLimitExceededBehavior() {
        return this.limitExceededBehavior;
    }

    public long getMaxOutstandingRequestSizeInBytes() {
        return this.maxOutstandingRequestSizeUnit.toBytes((int)this.maxOutstandingRequestSize);
    }

    public long getMaxOutstandingElementCount() {
        return this.maxOutstandingElementCount;
    }
}

