/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.connection.provider;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.mulesoft.connector.googlepubsub.internal.connection.PubSubConnection;
import com.mulesoft.connector.googlepubsub.internal.connection.provider.BatchProcessingParams;
import com.mulesoft.connector.googlepubsub.internal.connection.provider.FlowControlParameters;
import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.threeten.bp.Duration;

@DisplayName(value="PubSub Connection")
public class PubSubConnectionProvider
implements CachedConnectionProvider<PubSubConnection>,
ConnectorConnectionProvider<PubSubConnection>,
Initialisable,
Disposable {
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    private static final String GOOGLE_CREDENTIALS_STRING = "{\n  \"type\": \"service_account\",\n  \"private_key_id\": \"%s\",\n  \"private_key\": \"%s\",\n  \"client_email\": \"%s\",\n  \"client_id\": \"%s\"\n}";
    @Parameter
    @Placement(order=4)
    @DisplayName(value="Private key id")
    @Example(value="375cab6a129414767fff22e2da00b7a95eea7459")
    @Summary(value="Identifier of the private key for service account. Part of service-credentials.")
    private String privateKeyId;
    @Parameter
    @Placement(order=5)
    @Example(value="100318222032322741685")
    @DisplayName(value="Client id")
    @Summary(value="Identifier of the client. Part of service-credentials.")
    private String clientId;
    @Parameter
    @Example(value="mule-demo-app@project-name.iam.gserviceaccount.com")
    @Placement(order=6)
    @DisplayName(value="Client email")
    @Summary(value="Client email for service account. Part of service-credentials.")
    private String clientEmail;
    @Text
    @Parameter
    @Placement(order=7)
    @Example(value="-----BEGIN PRIVATE KEY----- <private-key> -----END PRIVATE KEY-----")
    @DisplayName(value="Private key")
    @Summary(value="Private key for service account. Part of service-credentials.")
    private String privateKey;
    @ParameterGroup(name="Batching parameters")
    private BatchProcessingParams batchProcessingParams;
    @ParameterGroup(name="Flow control parameters")
    private FlowControlParameters flowControlParameters;

    public void initialise() {
        this.scheduler = this.schedulerService.ioScheduler(SchedulerConfig.config().withName("pubsub-connector-mule-io-scheduler-" + UUID.randomUUID()));
    }

    public void dispose() {
        this.scheduler.stop();
    }

    public PubSubConnection connect() throws ConnectionException {
        try {
            FixedCredentialsProvider credentialsProvider = FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(String.format(GOOGLE_CREDENTIALS_STRING, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId).getBytes())));
            SubscriberStubSettings subscriberStubSettings = ((SubscriberStubSettings.Builder)SubscriberStubSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credentialsProvider)).build();
            PublisherStubSettings.Builder publisherStubSettingsBuilder = PublisherStubSettings.newBuilder();
            ((PublisherStubSettings.Builder)publisherStubSettingsBuilder.setCredentialsProvider((CredentialsProvider)credentialsProvider)).publishSettings().setBatchingSettings(BatchingSettings.newBuilder().setDelayThreshold(Duration.ofMillis((long)this.batchProcessingParams.getPublishDelayThresholdInMillis())).setElementCountThreshold(Long.valueOf(this.batchProcessingParams.getMessageCountBatchSize())).setRequestByteThreshold(Long.valueOf(this.batchProcessingParams.getRequestSizeThresholdInBytes())).setIsEnabled(Boolean.valueOf(this.batchProcessingParams.isBatchingEnabled())).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingRequestBytes(Long.valueOf(this.flowControlParameters.getMaxOutstandingRequestSizeInBytes())).setLimitExceededBehavior(FlowController.LimitExceededBehavior.valueOf((String)this.flowControlParameters.getLimitExceededBehavior().getValue())).setMaxOutstandingElementCount(Long.valueOf(this.flowControlParameters.getMaxOutstandingElementCount())).build()).build()).setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(Duration.ZERO).setMaxAttempts(0).build()).build();
            return new PubSubConnection(publisherStubSettingsBuilder.build(), subscriberStubSettings, credentialsProvider, this.scheduler);
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }
}

