/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.error;

import com.google.api.gax.batching.FlowController;
import com.google.api.gax.rpc.ApiException;
import com.mulesoft.connector.googlepubsub.internal.error.PubSubErrorType;
import com.mulesoft.connector.googlepubsub.internal.error.exception.GooglePubSubException;
import com.mulesoft.connector.googlepubsub.internal.error.exception.GooglePubSubRuntimeException;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

public class PubSubExceptionHandler
extends ExceptionHandler {
    public Exception enrichException(Exception e) {
        if (e instanceof MuleException || e instanceof MuleRuntimeException) {
            return e;
        }
        return PubSubExceptionHandler.wrapException(e);
    }

    public static Exception wrapException(Exception e) {
        if (e instanceof FlowController.FlowControlRuntimeException) {
            return Optional.of(e.getCause()).filter(cause -> cause instanceof FlowController.MaxOutstandingElementCountReachedException).map(cause -> new GooglePubSubException(PubSubErrorType.MAX_OUTSTANDING_ELEMENT_COUNT_REACHED, (Throwable)cause)).orElseGet(() -> new GooglePubSubException(PubSubErrorType.MAX_OUTSTANDING_BATCH_SIZE_REACHED, e.getCause()));
        }
        return Optional.of(e).filter(ApiException.class::isInstance).map(ApiException.class::cast).map(ex -> PubSubErrorType.valueOf(ex.getStatusCode().getCode().name())).map(code -> new GooglePubSubException(code, e)).orElseGet(() -> new GooglePubSubRuntimeException(e));
    }
}

