/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.metadata;

import com.google.pubsub.v1.Topic;
import com.mulesoft.connector.googlepubsub.internal.connection.PubSubConnection;
import com.mulesoft.connector.googlepubsub.internal.metadata.GenericTopicBasedMetadataResolver;
import com.mulesoft.connector.googlepubsub.internal.operation.params.SubscriptionIdentifier;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

public class MessageListenerMetadataResolver
extends GenericTopicBasedMetadataResolver
implements OutputTypeResolver<SubscriptionIdentifier>,
AttributesTypeResolver<SubscriptionIdentifier> {
    public String getResolverName() {
        return "MessageListenerMetadataResolver";
    }

    public MetadataType getOutputType(MetadataContext context, SubscriptionIdentifier identifier) throws MetadataResolvingException, ConnectionException {
        PubSubConnection pubSubConnection = this.getConnection(context);
        String topicId = pubSubConnection.getSubscription(identifier.getProjectId(), identifier.getSubscriptionName()).getTopic();
        Topic topic = pubSubConnection.getTopic(topicId);
        return this.resolveMetadata(pubSubConnection, topic);
    }

    public String getCategoryName() {
        return "messageListenerOutputResolver";
    }

    public MetadataType getAttributesType(MetadataContext context, SubscriptionIdentifier identifier) {
        ObjectTypeBuilder object = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).objectType();
        object.id("messageAttributes");
        object.addField().key("messageId").value().stringType();
        object.addField().key("publishTime").value().dateTimeType();
        object.addField().key("orderingKey").value().stringType();
        return object.build();
    }
}

