/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.operation;

import com.google.api.core.ApiFuture;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.mulesoft.connector.googlepubsub.internal.config.PubSubConfiguration;
import com.mulesoft.connector.googlepubsub.internal.connection.PubSubConnection;
import com.mulesoft.connector.googlepubsub.internal.error.provider.CommonErrorTypeProvider;
import com.mulesoft.connector.googlepubsub.internal.error.provider.PublishErrorTypeProvider;
import com.mulesoft.connector.googlepubsub.internal.operation.params.MessageContent;
import com.mulesoft.connector.googlepubsub.internal.operation.params.TopicIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishOperation {
    private static final Logger logger = LoggerFactory.getLogger(PublishOperation.class);

    @DisplayName(value="Publish Message")
    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class, PublishErrorTypeProvider.class})
    @Summary(value="Publish message and attributes to selected topic")
    public void publishMessage(@Config PubSubConfiguration config, @Connection PubSubConnection connection, @ParameterGroup(name="Topic settings") @MetadataKeyId TopicIdentifier topicIdentifier, @ParameterGroup(name="Message content") MessageContent messageContent, @org.mule.runtime.extension.api.annotation.param.Optional String orderingKey, CompletionCallback<String, Void> callback) {
        PubsubMessage.Builder pubSubMessageBuilder = PubsubMessage.newBuilder().putAllAttributes(messageContent.getAttributes());
        if (messageContent.getMessage() != null) {
            try {
                pubSubMessageBuilder.setData(ByteString.readFrom((InputStream)messageContent.getMessage()));
            }
            catch (IOException e) {
                logger.error("Error reading data from message content input stream", (Throwable)e);
                callback.error((Throwable)new MuleRuntimeException(e.getCause()));
            }
        }
        if (orderingKey != null) {
            pubSubMessageBuilder.setOrderingKey(orderingKey);
        }
        ApiFuture<PublishResponse> apiFuture = connection.publishMessage(PublishRequest.newBuilder().addMessages(pubSubMessageBuilder.build()).setTopic(String.format("projects/%s/topics/%s", topicIdentifier.getProjectId(), topicIdentifier.getTopicName())).build());
        apiFuture.addListener(() -> {
            try {
                Optional<String> messageId = ((PublishResponse)apiFuture.get()).getMessageIdsList().asByteStringList().stream().findFirst().map(ByteString::toStringUtf8);
                if (messageId.isPresent()) {
                    callback.success(Result.builder().output((Object)messageId.get()).build());
                } else {
                    callback.error((Throwable)new IllegalStateException("MessageId not returned! Message not delivered."));
                }
            }
            catch (Exception e) {
                callback.error(e.getCause());
            }
        }, (Executor)connection.getIoScheduler());
    }
}

