/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.operation;

import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.SeekRequest;
import com.mulesoft.connector.googlepubsub.internal.config.PubSubConfiguration;
import com.mulesoft.connector.googlepubsub.internal.connection.PubSubConnection;
import com.mulesoft.connector.googlepubsub.internal.error.provider.CommonErrorTypeProvider;
import com.mulesoft.connector.googlepubsub.internal.operation.params.SeekTarget;
import com.mulesoft.connector.googlepubsub.internal.operation.params.SubscriptionIdentifier;
import java.time.ZoneOffset;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class SeekOperation {
    @Throws(value={CommonErrorTypeProvider.class})
    @Summary(value="Replay or purge messages from selected snapshot or time")
    public void seekMessages(@Config PubSubConfiguration config, @Connection PubSubConnection connection, @ParameterGroup(name="Subscription settings") SubscriptionIdentifier subscriptionIdentifier, @ParameterGroup(name="Seek target") SeekTarget seekTarget) {
        SeekRequest.Builder seekRequestOrBuilder = SeekRequest.newBuilder().setSubscription(String.format("projects/%s/subscriptions/%s", subscriptionIdentifier.getProjectId(), subscriptionIdentifier.getSubscriptionName()));
        if (seekTarget.getTimestamp() != null) {
            seekRequestOrBuilder.setTime(Timestamp.newBuilder().setSeconds(seekTarget.getTimestamp().toEpochSecond(ZoneOffset.UTC)).build());
        }
        if (seekTarget.getSnapshotName() != null) {
            seekRequestOrBuilder.setSnapshot(String.format("projects/%s/snapshots/%s", subscriptionIdentifier.getProjectId(), seekTarget.getSnapshotName()));
        }
        connection.seekMessages(seekRequestOrBuilder.build());
    }
}

