/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.operation;

import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.GetSnapshotRequest;
import com.mulesoft.connector.googlepubsub.api.model.Snapshot;
import com.mulesoft.connector.googlepubsub.internal.config.PubSubConfiguration;
import com.mulesoft.connector.googlepubsub.internal.connection.PubSubConnection;
import com.mulesoft.connector.googlepubsub.internal.error.provider.CommonErrorTypeProvider;
import com.mulesoft.connector.googlepubsub.internal.error.provider.CreateOpErrorTypeProvider;
import com.mulesoft.connector.googlepubsub.internal.metadata.SnapshotMetadataResolver;
import com.mulesoft.connector.googlepubsub.internal.operation.params.SnapshotIdentifier;
import com.mulesoft.connector.googlepubsub.internal.operation.params.SubscriptionIdentifier;
import com.mulesoft.connector.googlepubsub.internal.pagination.SnapshotsPagingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class SnapshotOperations {
    private static final String APPLICATION_JAVA = "application/java";

    @MediaType(value="application/java")
    @OutputResolver(output=SnapshotMetadataResolver.class)
    @Summary(value="Creates new snapshot on selected subscription")
    @Throws(value={CommonErrorTypeProvider.class, CreateOpErrorTypeProvider.class})
    public Snapshot createSnapshot(@Config PubSubConfiguration config, @Connection PubSubConnection connection, @ParameterGroup(name="Subscription settings") SubscriptionIdentifier subscriptionIdentifier, String snapshotName, @Summary(value="key-value pairs used for easier resource filtering") @Optional @NullSafe @Content Map<String, String> labels, StreamingHelper streamingHelper) {
        return connection.createSnapshot(CreateSnapshotRequest.newBuilder().setName(String.format("projects/%s/snapshots/%s", subscriptionIdentifier.getProjectId(), snapshotName)).setSubscription(String.format("projects/%s/subscriptions/%s", subscriptionIdentifier.getProjectId(), subscriptionIdentifier.getSubscriptionName())).putAllLabels(labels).build());
    }

    @MediaType(value="application/java")
    @OutputResolver(output=SnapshotMetadataResolver.class)
    @Summary(value="Updates selected snapshot")
    @Throws(value={CommonErrorTypeProvider.class})
    public Snapshot patchSnapshot(@Config PubSubConfiguration config, @Connection PubSubConnection connection, @Content @InputJsonType(schema="metadata/patch-snapshot-request.json") InputStream snapshot, @Example(value="snapshot.expireTime, snapshot.labels") String updateMask) throws IOException {
        return connection.patchSnapshot(snapshot, updateMask);
    }

    @Summary(value="Deletes selected snapshot")
    @Throws(value={CommonErrorTypeProvider.class})
    public void deleteSnapshot(@Config PubSubConfiguration config, @Connection PubSubConnection connection, @ParameterGroup(name="Snapshot settings") SnapshotIdentifier snapshotIdentifier) {
        connection.deleteSnapshot(DeleteSnapshotRequest.newBuilder().setSnapshot(String.format("projects/%s/snapshots/%s", snapshotIdentifier.getProjectId(), snapshotIdentifier.getSnapshotName())).build());
    }

    @MediaType(value="application/java")
    @Summary(value="Retrieve a selected snapshot")
    @OutputResolver(output=SnapshotMetadataResolver.class)
    @Throws(value={CommonErrorTypeProvider.class})
    public Snapshot getSnapshot(@Config PubSubConfiguration config, @Connection PubSubConnection connection, @ParameterGroup(name="Snapshot settings") SnapshotIdentifier snapshotIdentifier) {
        return connection.getSnapshot(GetSnapshotRequest.newBuilder().setSnapshot(String.format("projects/%s/snapshots/%s", snapshotIdentifier.getProjectId(), snapshotIdentifier.getSnapshotName())).build());
    }

    @MediaType(value="application/java")
    @Summary(value="Retrieve list of all the existing snapshots in selected project")
    @Throws(value={CommonErrorTypeProvider.class})
    @OutputResolver(output=SnapshotMetadataResolver.class)
    public PagingProvider<PubSubConnection, Snapshot> getSnapshotList(@Config PubSubConfiguration config, @ConfigOverride String projectId) {
        return new SnapshotsPagingProvider(projectId);
    }
}

