/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.googlepubsub.internal.pagination;

import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.mulesoft.connector.googlepubsub.api.model.Snapshot;
import com.mulesoft.connector.googlepubsub.internal.connection.PubSubConnection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class SnapshotsPagingProvider
implements PagingProvider<PubSubConnection, Snapshot> {
    private final String projectId;
    private String pageToken = "";
    private boolean hasMore = true;

    public SnapshotsPagingProvider(String projectId) {
        this.projectId = projectId;
    }

    public List<Snapshot> getPage(PubSubConnection connection) {
        if (this.hasMore) {
            ListSnapshotsRequest.Builder request = ListSnapshotsRequest.newBuilder().setProject(String.format("projects/%s", this.projectId)).setPageSize(100);
            ListSnapshotsResponse response = connection.getSnapshotsListResponse(request.setPageToken(this.pageToken).build());
            this.pageToken = response.getNextPageToken();
            this.hasMore = !this.pageToken.isEmpty();
            return response.getSnapshotsList().stream().map(PubSubConnection::fromPubSubSnapshot).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Optional<Integer> getTotalResults(PubSubConnection connection) {
        return Optional.empty();
    }

    public void close(PubSubConnection connection) {
    }
}

