/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.internal.connection.provider;

import com.mulesoft.connectors.mqtt3.api.clientId.ClientIDGenerator;
import com.mulesoft.connectors.mqtt3.internal.connection.DefaultMQTT3Connection;
import com.mulesoft.connectors.mqtt3.internal.connection.MQTT3Connection;
import com.mulesoft.connectors.mqtt3.internal.connection.MQTT3ConnectionOptions;
import com.mulesoft.connectors.mqtt3.internal.connection.MQTT3FilePersistenceOptions;
import com.mulesoft.connectors.mqtt3.internal.routing.LWTMessage;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.Username;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQTT3ConnectionProvider
implements CachedConnectionProvider<MQTT3Connection>,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTT3ConnectionProvider.class);
    @Parameter
    @Summary(value="The generator used to create a connection's client id")
    protected ClientIDGenerator clientIDGenerator;
    @Parameter
    @Optional
    @Username
    @Summary(value="The username used when providing authentication credentials to the MQTT broker")
    protected String username;
    @Parameter
    @Optional
    @Password
    @Summary(value="The password to be used when providing authentication credentials to the MQTT broker")
    protected String password;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="SSL/TLS")
    @DisplayName(value="TLS Context")
    @Summary(value="The TLS factory used to create TLS secured connections")
    protected TlsContextFactory tlsContextFactory;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="LWT")
    @DisplayName(value="Last Will and Testament (LWT)")
    @ParameterGroup(name="Last Will and Testament", showInDsl=true)
    @Summary(value="The Last Will And Testament message to be set for this client")
    protected LWTMessage lastWillAndTestament;
    @NullSafe
    @ParameterGroup(name="Connection Options", showInDsl=true)
    @Summary(value="A group of advanced connection options")
    protected MQTT3ConnectionOptions connectionOptions;
    @NullSafe
    @ParameterGroup(name="File Persistence Options", showInDsl=true)
    protected MQTT3FilePersistenceOptions filePersistenceOptions;

    public void initialise() throws InitialisationException {
        if (this.lastWillAndTestament.getBody() == null && this.lastWillAndTestament.getTopic() != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Last will and testament message topic provided, but message content was not found."), (Initialisable)this);
        }
        if (this.lastWillAndTestament.getBody() != null && this.lastWillAndTestament.getTopic() == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Last will and testament message content provided, but topic was not found."), (Initialisable)this);
        }
    }

    public MQTT3Connection connect() throws ConnectionException {
        LOGGER.debug("Attempting to establish connection to MQTT3 broker.");
        DefaultMQTT3Connection mqtt3Connection = new DefaultMQTT3Connection(this.getUrl(), this.clientIDGenerator.generateClientID(), this.connectionOptions, this.filePersistenceOptions, this.lastWillAndTestament);
        mqtt3Connection.setUsernamePassword(this.username, this.password);
        if (this.tlsContextFactory != null) {
            mqtt3Connection.setTLSOptions(this.tlsContextFactory);
        }
        this.configureMqttConnectOptions(mqtt3Connection);
        mqtt3Connection.connect();
        return mqtt3Connection;
    }

    protected abstract void configureMqttConnectOptions(MQTT3Connection var1) throws ConnectionException;

    protected abstract String getUrl();

    public void disconnect(MQTT3Connection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to disconnect: {}", (Object)connection.hashCode());
        }
        connection.disconnect();
    }

    public ConnectionValidationResult validate(MQTT3Connection connection) {
        LOGGER.debug("Validating Connection");
        if (connection == null) {
            return ConnectionValidationResult.failure((String)"Disconnected", (Exception)new IllegalStateException("Disconnected"));
        }
        return connection.isConnected() ? ConnectionValidationResult.success() : ConnectionValidationResult.failure((String)"Disconnected", (Exception)new IllegalStateException("Disconnected"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MQTT3ConnectionProvider)) {
            return false;
        }
        MQTT3ConnectionProvider that = (MQTT3ConnectionProvider)o;
        return new EqualsBuilder().append((Object)this.clientIDGenerator, (Object)that.clientIDGenerator).append((Object)this.username, (Object)that.username).append((Object)this.password, (Object)that.password).append((Object)this.tlsContextFactory, (Object)that.tlsContextFactory).append((Object)this.lastWillAndTestament, (Object)that.lastWillAndTestament).append((Object)this.connectionOptions, (Object)that.connectionOptions).append((Object)this.filePersistenceOptions, (Object)that.filePersistenceOptions).isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.clientIDGenerator, this.username, this.password, this.tlsContextFactory, this.lastWillAndTestament, this.connectionOptions, this.filePersistenceOptions);
    }
}

